/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.core;

import java.util.LinkedHashSet;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.MultiFileSystem;
import org.praxislive.ide.core.api.DynamicFileSystem;

public class DynamicFileSystemImpl
extends MultiFileSystem
implements DynamicFileSystem {
    private final LinkedHashSet<FileSystem> mounted;

    public DynamicFileSystemImpl() {
        this.setPropagateMasks(true);
        this.mounted = new LinkedHashSet();
    }

    @Override
    public void mount(FileSystem fs) {
        if (fs == null) {
            throw new NullPointerException();
        }
        if (this.mounted.add(fs)) {
            this.refresh();
        }
    }

    @Override
    public void unmount(FileSystem fs) {
        if (this.mounted.remove(fs)) {
            this.refresh();
        }
    }

    @Override
    public boolean isMounted(FileSystem fs) {
        return this.mounted.contains(fs);
    }

    public boolean isReadOnly() {
        return true;
    }

    private void refresh() {
        this.setDelegates(this.mounted.toArray(new FileSystem[this.mounted.size()]));
    }
}

