/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.core.api;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.praxislive.base.AbstractComponent;
import org.praxislive.base.Binding;
import org.praxislive.base.BindingContext;
import org.praxislive.core.Call;
import org.praxislive.core.ComponentAddress;
import org.praxislive.core.ComponentInfo;
import org.praxislive.core.Control;
import org.praxislive.core.ControlAddress;
import org.praxislive.core.ExecutionContext;
import org.praxislive.core.Info;
import org.praxislive.core.Packet;
import org.praxislive.core.PacketRouter;
import org.praxislive.core.Value;
import org.praxislive.core.services.ScriptService;
import org.praxislive.core.services.Service;
import org.praxislive.core.services.ServiceUnavailableException;
import org.praxislive.core.types.PString;
import org.praxislive.ide.core.api.Callback;
import org.praxislive.ide.core.api.HubUnavailableException;

public class AbstractHelperComponent
extends AbstractComponent {
    public static final String PROP_HUB_CONNECTED = "connected";
    private final PropertyChangeSupport pcs = new PropertyChangeSupport((Object)this);
    private final SendControl sender;
    private final String sendID = "_send_" + Integer.toHexString(System.identityHashCode((Object)this));
    private boolean connected;
    private BindingContext bindingContext;
    private PacketRouter router;
    private ExecutionContext context;

    protected AbstractHelperComponent() {
        this.sender = new SendControl();
        this.registerControl(this.sendID, this.sender);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    protected void firePropertyChange(String property, Object oldValue, Object newValue) {
        this.pcs.firePropertyChange(property, oldValue, newValue);
    }

    public void hierarchyChanged() {
        super.hierarchyChanged();
        this.router = this.getLookup().find(PacketRouter.class).orElse(null);
        this.context = this.getLookup().find(ExecutionContext.class).orElse(null);
        this.bindingContext = this.getLookup().find(BindingContext.class).orElse(null);
        if (this.connected) {
            if (this.bindingContext == null) {
                this.connected = false;
                this.pcs.firePropertyChange(PROP_HUB_CONNECTED, true, false);
            }
        } else if (this.bindingContext != null) {
            this.connected = true;
            this.sender.fromAddress = ControlAddress.of((ComponentAddress)this.getAddress(), (String)this.sendID);
            this.pcs.firePropertyChange(PROP_HUB_CONNECTED, false, true);
        }
    }

    public final boolean isConnected() {
        return this.connected;
    }

    public ComponentAddress findService(Class<? extends Service> service) throws ServiceUnavailableException {
        return super.findService(service);
    }

    public void send(ControlAddress to, List<Value> args, Callback callback) throws HubUnavailableException {
        this.sender.send(to, args, callback);
    }

    public CompletionStage<List<Value>> send(ControlAddress to, List<Value> args) {
        try {
            CompletableFuture<List<Value>> future = new CompletableFuture<List<Value>>();
            this.send(to, args, Callback.create(future));
            return future.minimalCompletionStage();
        }
        catch (HubUnavailableException ex) {
            return CompletableFuture.failedStage(ex);
        }
    }

    public void send(Class<? extends Service> service, String control, List<Value> args, Callback callback) throws HubUnavailableException, ServiceUnavailableException {
        ControlAddress to = ControlAddress.of((ComponentAddress)this.findService(service), (String)control);
        this.send(to, args, callback);
    }

    public CompletionStage<List<Value>> send(Class<? extends Service> service, String control, List<Value> args) {
        try {
            CompletableFuture<List<Value>> future = new CompletableFuture<List<Value>>();
            this.send(service, control, args, Callback.create(future));
            return future.minimalCompletionStage();
        }
        catch (Exception ex) {
            return CompletableFuture.failedStage(ex);
        }
    }

    public void execScript(String script, Callback callback) throws HubUnavailableException, ServiceUnavailableException {
        Objects.requireNonNull(script);
        this.send(ScriptService.class, "eval", List.of(PString.of((String)script)), callback);
    }

    public CompletionStage<List<Value>> execScript(String script) {
        try {
            CompletableFuture<List<Value>> future = new CompletableFuture<List<Value>>();
            this.execScript(script, Callback.create(future));
            return future.minimalCompletionStage();
        }
        catch (Exception ex) {
            return CompletableFuture.failedStage(ex);
        }
    }

    public void bind(ControlAddress address, Binding.Adaptor adaptor) {
        if (address == null || adaptor == null) {
            throw new NullPointerException();
        }
        this.bindingContext.bind(address, adaptor);
    }

    public void unbind(ControlAddress address, Binding.Adaptor adaptor) {
        if (adaptor == null) {
            throw new NullPointerException();
        }
        if (this.bindingContext != null) {
            this.bindingContext.unbind(address, adaptor);
        }
    }

    public ComponentInfo getInfo() {
        return Info.component().build();
    }

    private class SendControl
    implements Control {
        private final Map<Integer, Callback> pending = new HashMap<Integer, Callback>();
        private ControlAddress fromAddress;

        private SendControl() {
        }

        public void call(Call call, PacketRouter pr) throws Exception {
            if (call.isReply()) {
                this.handleResponse(call, false);
            } else if (call.isError()) {
                this.handleResponse(call, true);
            } else {
                throw new UnsupportedOperationException();
            }
        }

        private void handleResponse(Call call, boolean error) {
            Callback cb = this.pending.remove(call.matchID());
            if (cb != null) {
                if (error) {
                    cb.onError(call.args());
                } else {
                    cb.onReturn(call.args());
                }
            }
        }

        private void send(ControlAddress to, List<Value> args, Callback callback) throws HubUnavailableException {
            if (AbstractHelperComponent.this.router == null || AbstractHelperComponent.this.context == null || this.fromAddress == null) {
                throw new HubUnavailableException();
            }
            boolean quiet = callback == null;
            Call call = quiet ? Call.createQuiet((ControlAddress)to, (ControlAddress)this.fromAddress, (long)AbstractHelperComponent.this.context.getTime(), args) : Call.create((ControlAddress)to, (ControlAddress)this.fromAddress, (long)AbstractHelperComponent.this.context.getTime(), args);
            AbstractHelperComponent.this.router.route((Packet)call);
            if (!quiet) {
                this.pending.put(call.matchID(), callback);
            }
        }
    }
}

