/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.core.api;

import java.awt.EventQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Timer;
import org.praxislive.base.AbstractRoot;
import org.praxislive.base.AbstractRootContainer;
import org.praxislive.base.BindingContextControl;
import org.praxislive.core.ComponentAddress;
import org.praxislive.core.Control;
import org.praxislive.core.ControlAddress;
import org.praxislive.core.Lookup;

public abstract class AbstractIDERoot
extends AbstractRootContainer {
    private final boolean startOnActivation;
    private BindingContextControl bindings;
    private Lookup lookup;

    public AbstractIDERoot() {
        this(true);
    }

    public AbstractIDERoot(boolean startOnActivation) {
        this.startOnActivation = startOnActivation;
    }

    public Lookup getLookup() {
        return this.lookup == null ? super.getLookup() : this.lookup;
    }

    protected final void activating() {
        this.bindings = new BindingContextControl(ControlAddress.of((ComponentAddress)this.getAddress(), (String)"_bindings"), this.getExecutionContext(), this.getRouter());
        this.registerControl("_bindings", (Control)this.bindings);
        this.lookup = Lookup.of((Lookup)super.getLookup(), (Object[])new Object[]{this.bindings});
        SwingDelegate delegate = new SwingDelegate();
        this.attachDelegate(delegate);
        delegate.start();
    }

    protected final void terminating() {
    }

    protected void setup() {
    }

    protected void dispose() {
    }

    private class SwingDelegate
    extends AbstractRoot.Delegate {
        private final AtomicBoolean pollQueued;
        private Timer timer;

        private SwingDelegate() {
            super((AbstractRoot)AbstractIDERoot.this);
            this.pollQueued = new AtomicBoolean();
        }

        private void start() {
            EventQueue.invokeLater(() -> {
                AbstractIDERoot.this.setup();
                if (AbstractIDERoot.this.startOnActivation) {
                    AbstractIDERoot.this.setRunning();
                }
                this.timer = new Timer(50, e -> this.update());
                this.timer.start();
            });
        }

        private void update() {
            boolean ok = this.doUpdate(AbstractIDERoot.this.getRootHub().getClock().getTime());
            if (!ok) {
                this.timer.stop();
                AbstractIDERoot.this.dispose();
                AbstractIDERoot.this.detachDelegate(this);
            }
        }

        protected void onQueueReceipt() {
            if (this.pollQueued.compareAndSet(false, true)) {
                EventQueue.invokeLater(() -> {
                    this.pollQueued.set(false);
                    this.doPollQueue();
                });
            }
        }
    }
}

