/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.core.api;

import java.util.List;
import java.util.stream.Collectors;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.praxislive.core.Component;
import org.praxislive.core.ComponentInfo;
import org.praxislive.core.Info;
import org.praxislive.core.VetoException;
import org.praxislive.ide.core.api.AbstractIDERoot;
import org.praxislive.ide.core.spi.ExtensionProvider;

public final class ExtensionContainer
extends AbstractIDERoot {
    private static final ComponentInfo INFO = Info.component().build();
    private static final String EXT_PREFIX = "_ext_";
    private final List<Component> extensions;

    private ExtensionContainer(List<Component> extensions) {
        this.extensions = extensions;
    }

    protected void starting() {
        this.installExtensions();
    }

    protected void stopping() {
        this.uninstallExtensions();
    }

    private void installExtensions() {
        for (Component ext : this.extensions) {
            String id = EXT_PREFIX + Integer.toHexString(System.identityHashCode(ext));
            try {
                this.addChild(id, ext);
            }
            catch (VetoException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void uninstallExtensions() {
        String[] ids;
        for (String id : ids = (String[])this.children().toArray(String[]::new)) {
            this.removeChild(id);
        }
    }

    public ComponentInfo getInfo() {
        return INFO;
    }

    public List<Component> extensions() {
        return this.extensions;
    }

    public static ExtensionContainer create(Lookup context) {
        List exts = Lookup.getDefault().lookupAll(ExtensionProvider.class).stream().flatMap(p -> p.createExtension(context).stream()).collect(Collectors.toList());
        return new ExtensionContainer(List.copyOf(exts));
    }
}

