/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.core.api;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import org.praxislive.base.Binding;
import org.praxislive.core.Value;
import org.praxislive.core.types.PString;

public abstract class ValuePropertyAdaptor
extends Binding.Adaptor {
    private PropertyChangeSupport pcs;
    private String property;
    private boolean alwaysActive;
    private Value value = PString.EMPTY;

    public ValuePropertyAdaptor(Object source, String property, boolean alwaysActive, Binding.SyncRate rate) {
        if (property == null || rate == null) {
            throw new NullPointerException();
        }
        this.pcs = source == null ? new PropertyChangeSupport((Object)this) : new PropertyChangeSupport(source);
        this.property = property;
        this.alwaysActive = alwaysActive;
        this.setSyncRate(rate);
        if (alwaysActive) {
            this.setActive(true);
        }
    }

    void setValueImpl(Value value, boolean send) {
        if (value == null) {
            throw new NullPointerException();
        }
        Value oldValue = this.value;
        if (send) {
            this.send(List.of(value));
        }
        this.value = value;
        if (!oldValue.equivalent(value) && !value.equivalent(oldValue)) {
            this.pcs.firePropertyChange(this.property, oldValue, value);
        }
    }

    public Value getValue() {
        return this.value;
    }

    public void update() {
        List args;
        Binding binding = this.getBinding();
        Object arg = binding == null ? PString.EMPTY : ((args = binding.getValues()).isEmpty() ? PString.EMPTY : (Value)args.get(0));
        this.setValueImpl((Value)arg, false);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
        if (!this.alwaysActive) {
            this.setActive(true);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
        if (!this.alwaysActive && !this.pcs.hasListeners(null)) {
            this.setActive(false);
        }
    }

    public static class ReadOnly
    extends ValuePropertyAdaptor {
        public ReadOnly(Object source, String property, boolean alwaysActive, Binding.SyncRate rate) {
            super(source, property, alwaysActive, rate);
        }
    }

    public static class ReadWrite
    extends ValuePropertyAdaptor {
        public ReadWrite(Object source, String property, boolean alwaysActive, Binding.SyncRate rate) {
            super(source, property, alwaysActive, rate);
        }

        public void setValue(Value value) {
            this.setValueImpl(value, true);
        }
    }
}

