/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.core.api;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.List;
import java.util.Queue;
import java.util.function.Consumer;
import org.praxislive.ide.core.api.AbstractTask;
import org.praxislive.ide.core.api.Task;

public class SerialTasks
extends AbstractTask {
    private final Queue<Task> tasks;
    private final Listener listener;
    private Task activeTask;
    private Consumer<Task> before;
    private Consumer<Task> after;

    public SerialTasks(List<Task> tasks) {
        this.tasks = new ArrayDeque<Task>(tasks);
        this.listener = new Listener();
    }

    public SerialTasks(Task ... tasks) {
        this(Arrays.asList(tasks));
    }

    public int remaining() {
        return this.tasks.size();
    }

    protected void beforeExecute() {
    }

    protected void afterExecute() {
    }

    protected void beforeTask(Task task) {
    }

    protected void afterTask(Task task) {
    }

    @Override
    protected final void handleExecute() throws Exception {
        this.beforeExecute();
        if (this.tasks.isEmpty()) {
            this.updateState(Task.State.COMPLETED);
            this.afterExecute();
            return;
        }
        this.handleTaskQueue();
    }

    private void handleTaskQueue() {
        while (!this.tasks.isEmpty()) {
            this.activeTask = this.tasks.poll();
            Task.State state = this.activeTask.getState();
            if (state == Task.State.NEW) {
                this.beforeTask(this.activeTask);
                state = this.activeTask.execute();
            }
            if (state == Task.State.COMPLETED) {
                this.afterTask(this.activeTask);
            }
            if (state == Task.State.RUNNING) {
                this.activeTask.addPropertyChangeListener(this.listener);
                return;
            }
            if (state != Task.State.ERROR && state != Task.State.CANCELLED) continue;
            this.afterTask(this.activeTask);
            this.updateState(state);
            this.afterExecute();
            return;
        }
        this.updateState(Task.State.COMPLETED);
        this.afterExecute();
    }

    @Override
    protected boolean handleCancel() {
        boolean cancelled = true;
        if (this.activeTask != null) {
            cancelled = this.activeTask.cancel();
        }
        if (cancelled) {
            for (Task task : this.tasks) {
                task.cancel();
            }
        }
        return cancelled;
    }

    private class Listener
    implements PropertyChangeListener {
        private Listener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            assert (evt.getSource() == SerialTasks.this.activeTask);
            if (SerialTasks.this.getState() == Task.State.RUNNING && evt.getSource() == SerialTasks.this.activeTask) {
                Task.State taskState = SerialTasks.this.activeTask.getState();
                if (taskState == Task.State.RUNNING) {
                    assert (false);
                    return;
                }
                SerialTasks.this.activeTask.removePropertyChangeListener(this);
                if (taskState == Task.State.COMPLETED) {
                    SerialTasks.this.afterTask(SerialTasks.this.activeTask);
                    SerialTasks.this.handleTaskQueue();
                } else if (taskState == Task.State.CANCELLED || taskState == Task.State.ERROR) {
                    SerialTasks.this.afterTask(SerialTasks.this.activeTask);
                    SerialTasks.this.updateState(taskState);
                    SerialTasks.this.afterExecute();
                }
            }
        }
    }
}

