/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.editor.saveflash;

import java.util.Objects;
import javax.swing.JEditorPane;
import javax.swing.text.Document;
import javax.swing.text.Element;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.spi.editor.document.OnSaveTask;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;
import org.praxislive.ide.editor.saveflash.FlashOnSaveHighlight;

public class FlashOnSaveTask
implements OnSaveTask {
    private final OnSaveTask.Context context;

    private FlashOnSaveTask(OnSaveTask.Context context) {
        this.context = context;
    }

    public void performTask() {
        JEditorPane[] panes;
        EditorCookie ec;
        DataObject dob = NbEditorUtilities.getDataObject((Document)this.context.getDocument());
        if (dob != null && (ec = (EditorCookie)dob.getLookup().lookup(EditorCookie.class)) != null && (panes = ec.getOpenedPanes()) != null) {
            for (JEditorPane pane : panes) {
                this.performTask(pane);
            }
        }
    }

    private void performTask(JEditorPane pane) {
        Object prop = pane.getClientProperty(FlashOnSaveHighlight.class);
        Element root = this.context.getModificationsRootElement();
        if (prop instanceof FlashOnSaveHighlight && root != null) {
            ((FlashOnSaveHighlight)prop).highlight(root);
        }
    }

    public void runLocked(Runnable run) {
        run.run();
    }

    public boolean cancel() {
        return false;
    }

    public static class TaskFactory
    implements OnSaveTask.Factory {
        public OnSaveTask createTask(OnSaveTask.Context context) {
            return new FlashOnSaveTask(Objects.requireNonNull(context));
        }
    }
}

