/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.editor.saveflash;

import java.util.prefs.Preferences;
import javax.swing.Timer;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Utilities;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.spi.editor.highlighting.HighlightsChangeListener;
import org.netbeans.spi.editor.highlighting.HighlightsContainer;
import org.netbeans.spi.editor.highlighting.HighlightsLayer;
import org.netbeans.spi.editor.highlighting.HighlightsLayerFactory;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.ZOrder;
import org.netbeans.spi.editor.highlighting.support.OffsetsBag;
import org.openide.util.Exceptions;

public class FlashOnSaveHighlight
implements HighlightsContainer {
    private static final int DELAY = 500;
    static final String ENABLED_KEY = "flash-enabled";
    static boolean enabled = ((Preferences)MimeLookup.getLookup((MimePath)MimePath.EMPTY).lookup(Preferences.class)).getBoolean("flash-enabled", false);
    private final OffsetsBag bag;
    private final AttributeSet attributes;
    private final JTextComponent component;
    private final Timer timer;

    private FlashOnSaveHighlight(JTextComponent component) {
        String mimeType = FlashOnSaveHighlight.getMimeType(component);
        MimePath mimePath = mimeType == null ? MimePath.EMPTY : MimePath.parse((String)mimeType);
        this.attributes = FlashOnSaveHighlight.getAttributes(mimePath);
        this.component = component;
        this.bag = new OffsetsBag(component.getDocument());
        this.timer = new Timer(500, e -> this.bag.clear());
        this.timer.setRepeats(false);
    }

    public HighlightsSequence getHighlights(int startOffset, int endOffset) {
        return this.bag.getHighlights(startOffset, endOffset);
    }

    public void addHighlightsChangeListener(HighlightsChangeListener listener) {
        this.bag.addHighlightsChangeListener(listener);
    }

    public void removeHighlightsChangeListener(HighlightsChangeListener listener) {
        this.bag.removeHighlightsChangeListener(listener);
    }

    void highlight(Element root) {
        if (!enabled) {
            return;
        }
        try {
            int count = root.getElementCount();
            if (count == 0) {
                this.bag.addHighlight(root.getStartOffset(), root.getEndOffset(), this.attributes);
            } else {
                for (int i = 0; i < root.getElementCount(); ++i) {
                    Element e = root.getElement(i);
                    int start = Utilities.getRowStart(this.component, e.getStartOffset());
                    int end = Utilities.getRowEnd(this.component, e.getEndOffset());
                    if (start < 0 || end < 0) continue;
                    String text = this.component.getDocument().getText(start, end - start);
                    this.bag.addHighlight(start, end + (text.endsWith("\n") ? 0 : 1), this.attributes);
                }
            }
            this.timer.restart();
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static AttributeSet getAttributes(MimePath mimePath) {
        FontColorSettings fcs = (FontColorSettings)MimeLookup.getLookup((MimePath)mimePath).lookup(FontColorSettings.class);
        AttributeSet attribs = fcs.getFontColors("inc-search");
        if (attribs != null) {
            return AttributesUtilities.createImmutable((AttributeSet[])new AttributeSet[]{attribs, AttributesUtilities.createImmutable((Object[])new Object[]{"org.netbeans.spi.editor.highlighting.HighlightsContainer.ATTR_EXTENDS_EMPTY_LINE", Boolean.TRUE, "org.netbeans.spi.editor.highlighting.HighlightsContainer.ATTR_EXTENDS_EOL", Boolean.TRUE})});
        }
        return SimpleAttributeSet.EMPTY;
    }

    private static String getMimeType(JTextComponent component) {
        EditorKit kit;
        Document doc = component.getDocument();
        String mime = (String)doc.getProperty("mimeType");
        if (mime == null && (kit = component.getUI().getEditorKit(component)) != null) {
            mime = kit.getContentType();
        }
        return mime;
    }

    public static class Factory
    implements HighlightsLayerFactory {
        public HighlightsLayer[] createLayers(HighlightsLayerFactory.Context context) {
            FlashOnSaveHighlight hl = new FlashOnSaveHighlight(context.getComponent());
            context.getComponent().putClientProperty(FlashOnSaveHighlight.class, hl);
            return new HighlightsLayer[]{HighlightsLayer.create((String)FlashOnSaveHighlight.class.getName(), (ZOrder)ZOrder.TOP_RACK.forPosition(10000), (boolean)false, (HighlightsContainer)hl)};
        }
    }
}

