/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.model;

import java.util.Optional;
import java.util.stream.Stream;
import org.praxislive.core.ComponentAddress;
import org.praxislive.ide.model.ComponentProxy;
import org.praxislive.ide.model.ContainerProxy;
import org.praxislive.ide.model.Proxy;
import org.praxislive.ide.model.RootProxy;

public interface HubProxy
extends Proxy {
    public static final String ROOTS = "roots";

    public RootProxy getRoot(String var1);

    public Stream<String> roots();

    default public Optional<ComponentProxy> find(ComponentAddress address) {
        RootProxy root = this.getRoot(address.rootID());
        if (root == null) {
            return Optional.empty();
        }
        if (address.depth() == 1) {
            return Optional.of(root);
        }
        ComponentProxy cmp = root;
        for (int i = 1; i < address.depth(); ++i) {
            if (!(cmp instanceof ContainerProxy)) {
                return Optional.empty();
            }
            cmp = ((ContainerProxy)cmp).getChild(address.componentID(i));
        }
        return Optional.ofNullable(cmp);
    }
}

