/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.project.templates;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.praxislive.ide.project.templates.TemplateProjectWizardPanel;

public class TemplateProjectWizardIterator
implements WizardDescriptor.InstantiatingIterator {
    private int index;
    private WizardDescriptor.Panel[] panels;
    private WizardDescriptor wiz;

    public static TemplateProjectWizardIterator createIterator() {
        return new TemplateProjectWizardIterator();
    }

    private WizardDescriptor.Panel[] createPanels() {
        return new WizardDescriptor.Panel[]{new TemplateProjectWizardPanel()};
    }

    private String[] createSteps() {
        return new String[]{NbBundle.getMessage(TemplateProjectWizardIterator.class, (String)"LBL_CreateProjectStep")};
    }

    public Set instantiate() throws IOException {
        LinkedHashSet<FileObject> resultSet = new LinkedHashSet<FileObject>();
        File dirF = FileUtil.normalizeFile((File)((File)this.wiz.getProperty("projdir")));
        dirF.mkdirs();
        FileObject template = Templates.getTemplate((WizardDescriptor)this.wiz);
        String examplePath = template.getAttribute("zipPath").toString();
        FileObject dir = FileUtil.toFileObject((File)dirF);
        try {
            TemplateProjectWizardIterator.unZipExample(dir, examplePath);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        resultSet.add(dir);
        File parent = dirF.getParentFile();
        if (parent != null && parent.exists()) {
            ProjectChooser.setProjectsFolder((File)parent);
        }
        return resultSet;
    }

    public void initialize(WizardDescriptor wiz) {
        this.wiz = wiz;
        wiz.putProperty("name", (Object)Templates.getTemplate((WizardDescriptor)wiz).getName());
        this.index = 0;
        this.panels = this.createPanels();
        String[] steps = this.createSteps();
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    public void uninitialize(WizardDescriptor wiz) {
        this.wiz.putProperty("projdir", null);
        this.wiz.putProperty("name", null);
        this.wiz = null;
        this.panels = null;
    }

    public String name() {
        return MessageFormat.format("{0} of {1}", this.index + 1, this.panels.length);
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener l) {
    }

    public final void removeChangeListener(ChangeListener l) {
    }

    private static void unZipExample(FileObject projectDir, String examplePath) throws Exception {
        FileObject exampleZip = FileUtil.getConfigFile((String)"Templates/templates.zip");
        FileObject zipRoot = FileUtil.getArchiveRoot((FileObject)exampleZip);
        FileObject exampleProject = zipRoot.getFileObject(examplePath);
        for (FileObject fo : exampleProject.getChildren()) {
            fo.copy(projectDir, fo.getName(), fo.getExt());
        }
    }
}

