/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.project.templates;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.Objects;
import java.util.prefs.Preferences;
import java.util.stream.Stream;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.XMLFileSystem;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.praxislive.ide.core.api.DynamicFileSystem;
import org.praxislive.ide.core.api.IDE;

class TemplateUtils {
    static final RequestProcessor RP = new RequestProcessor("Templates");
    static final String KEY_EXAMPLES_LINK = "project-templates-link";
    static final String KEY_EXAMPLES_LINK_INSTALLED = "project-templates-link-installed";
    static final String LAYER_FILE_NAME = "layer.xml";
    static final String EXAMPLE_FILE_NAME = "templates.zip";
    static final String CONFIG_PATH = "Templates";
    static final String CONFIG_LAYER_PATH = "Templates/layer.xml";
    static final String CONFIG_ZIP_PATH = "Templates/templates.zip";
    static final String ZIP_PATH_ATTRIBUTE = "zipPath";
    private static final Preferences info = IDE.getPreferences();
    private static XMLFileSystem layer;

    private TemplateUtils() {
    }

    static boolean isInstalled() {
        return !info.get(KEY_EXAMPLES_LINK_INSTALLED, "").isEmpty() && FileUtil.getConfigFile((String)CONFIG_ZIP_PATH) != null;
    }

    static boolean isLatest() {
        return Objects.equals(info.get(KEY_EXAMPLES_LINK, ""), info.get(KEY_EXAMPLES_LINK_INSTALLED, ""));
    }

    static boolean canInstall() {
        return !info.get(KEY_EXAMPLES_LINK, "").isEmpty();
    }

    static void install() throws IOException {
        FileObject layerFile = FileUtil.getConfigFile((String)CONFIG_LAYER_PATH);
        if (layerFile != null) {
            layerFile.delete();
        }
        if (layer != null) {
            DynamicFileSystem.getDefault().unmount((FileSystem)layer);
            layer = null;
        }
        if (!TemplateUtils.isInstalled() || !TemplateUtils.isLatest()) {
            TemplateUtils.downloadZip();
        }
        TemplateUtils.mountLayer();
        info.put(KEY_EXAMPLES_LINK_INSTALLED, info.get(KEY_EXAMPLES_LINK, ""));
    }

    static FileObject downloadZip() throws IOException {
        FileObject zip = FileUtil.getConfigFile((String)CONFIG_ZIP_PATH);
        if (zip != null) {
            zip.delete();
        }
        FileObject folder = FileUtil.createFolder((FileObject)FileUtil.getConfigRoot(), (String)CONFIG_PATH);
        zip = FileUtil.createData((FileObject)folder, (String)EXAMPLE_FILE_NAME);
        try (InputStream in = new URL(info.get(KEY_EXAMPLES_LINK, "")).openStream();
             OutputStream out = zip.getOutputStream();){
            FileUtil.copy((InputStream)in, (OutputStream)out);
        }
        catch (IOException ex) {
            info.remove(KEY_EXAMPLES_LINK_INSTALLED);
            zip.delete();
            throw ex;
        }
        return zip;
    }

    static void mountLayer() {
        FileObject layerFile;
        DynamicFileSystem dfs = DynamicFileSystem.getDefault();
        if (layer != null) {
            dfs.unmount((FileSystem)layer);
            layer = null;
        }
        if ((layerFile = TemplateUtils.findLayerFile()) != null) {
            try {
                layer = new XMLFileSystem(layerFile.toURL());
                dfs.mount((FileSystem)layer);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    static FileObject findLayerFile() {
        FileObject layerFile = FileUtil.getConfigFile((String)CONFIG_LAYER_PATH);
        if (layerFile != null) {
            return layerFile;
        }
        FileObject examplesZip = FileUtil.getConfigFile((String)CONFIG_ZIP_PATH);
        if (examplesZip != null) {
            return TemplateUtils.writeLayerFile(examplesZip);
        }
        return null;
    }

    private static FileObject writeLayerFile(FileObject examplesZip) {
        try {
            FileObject exampleRoot = FileUtil.getArchiveRoot((FileObject)examplesZip);
            FileObject[] children = exampleRoot.getChildren();
            if (children.length == 0) {
                return null;
            }
            if (children.length == 1) {
                if (children[0].isFolder()) {
                    exampleRoot = children[0];
                } else {
                    return null;
                }
            }
            StringBuilder sb = new StringBuilder();
            TemplateUtils.writeLayerPrefix(sb);
            TemplateUtils.writeFolderProjects(sb, exampleRoot, 1000);
            TemplateUtils.writeLayerSuffix(sb);
            FileObject layerFile = FileUtil.createData((FileObject)FileUtil.getConfigFile((String)CONFIG_PATH), (String)LAYER_FILE_NAME);
            try (OutputStreamWriter out = new OutputStreamWriter(layerFile.getOutputStream());){
                out.append(sb);
            }
            return layerFile;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    private static void writeFolderProjects(StringBuilder sb, FileObject folder, int position) {
        String[] children;
        for (String child : children = (String[])Stream.of(folder.getChildren()).map(FileObject::getNameExt).sorted().toArray(String[]::new)) {
            FileObject file = folder.getFileObject(child);
            if (!file.isFolder()) continue;
            if (file.getFileObject("project.pxp") != null) {
                TemplateUtils.writeTemplateFile(sb, file);
                continue;
            }
            String folderName = file.getName();
            sb.append("<folder name=\"").append(folderName).append("\">");
            if (!"PraxisCORE".equals(folderName)) {
                sb.append("<attr name=\"position\" intvalue=\"").append(position).append("\"/>\n");
                position += 100;
            }
            TemplateUtils.writeFolderProjects(sb, file, 0);
            sb.append("</folder>");
        }
    }

    private static void writeLayerPrefix(StringBuilder sb) {
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sb.append("<!DOCTYPE filesystem PUBLIC \"-//NetBeans//DTD Filesystem 1.2//EN\" \"http://www.netbeans.org/dtds/filesystem-1_2.dtd\">\n");
        sb.append("<filesystem>\n");
        sb.append("<folder name=\"Templates\">\n");
        sb.append("<folder name=\"Project\">\n");
    }

    private static void writeTemplateFile(StringBuilder sb, FileObject project) {
        String path = project.getPath();
        sb.append("<file name=\"").append(project.getName()).append("\">\n");
        sb.append("<attr name=\"instantiatingIterator\" newvalue=\"org.praxislive.ide.project.templates.TemplateProjectWizardIterator\"/>\n");
        sb.append("<attr name=\"template\" boolvalue=\"true\"/>\n");
        sb.append("<attr name=\"SystemFileSystem.icon\" urlvalue=\"nbresloc:/org/praxislive/ide/project/resources/pxp16.png\"/>\n");
        sb.append("<attr name=\"zipPath\" stringvalue=\"").append(path).append("\"/>\n");
        sb.append("</file>\n");
    }

    private static void writeLayerSuffix(StringBuilder sb) {
        sb.append("</folder>\n");
        sb.append("</folder>\n");
        sb.append("</filesystem>");
    }
}

