package org.praxislive.ide.project;
/** Localizable strings for {@link org.praxislive.ide.project}. */
class Bundle {
    /**
     * @param library_URI library URI
     * @return <i>Error adding library </i>{@code library_URI}
     * @see ProjectPropertiesImpl
     */
    static String ERR_addLibraryError(Object library_URI) {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "ERR_addLibraryError", library_URI);
    }
    /**
     * @return <i>Continue building project?</i>
     * @see DefaultPraxisProject
     */
    static String ERR_elementContinueBuild() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "ERR_elementContinueBuild");
    }
    /**
     * @return <i>Continue running project?</i>
     * @see DefaultPraxisProject
     */
    static String ERR_elementContinueRun() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "ERR_elementContinueRun");
    }
    /**
     * @param path_or_command path or command
     * @return <i>Error executing </i>{@code path_or_command}
     * @see DefaultPraxisProject
     */
    static String ERR_elementExecution(Object path_or_command) {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "ERR_elementExecution", path_or_command);
    }
    /**
     * @param required_Java_release required Java release
     * @return <i>This project requires Java </i>{@code required_Java_release}
     * @see DefaultPraxisProject
     */
    static String PraxisProject_javaVersionError(Object required_Java_release) {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "PraxisProject.javaVersionError", required_Java_release);
    }
    /**
     * @return <i>Stop project</i>
     * @see ChildLauncherImpl
     */
    static String TXT_StopExecution() {
        return org.openide.util.NbBundle.getMessage(Bundle.class, "TXT_StopExecution");
    }
    private Bundle() {}
}
