/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.project;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.extexecution.base.Environment;
import org.netbeans.api.extexecution.base.ProcessBuilder;
import org.netbeans.api.extexecution.base.input.InputProcessor;
import org.netbeans.api.extexecution.base.input.InputProcessors;
import org.netbeans.api.extexecution.base.input.LineProcessor;
import org.openide.util.ImageUtilities;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.praxislive.core.types.PArray;
import org.praxislive.core.types.PString;
import org.praxislive.hub.net.ChildLauncher;
import org.praxislive.ide.core.embedder.CORE;
import org.praxislive.ide.project.Bundle;
import org.praxislive.ide.project.DefaultPraxisProject;

class ChildLauncherImpl
implements ChildLauncher {
    private static final Map<DefaultPraxisProject, InputOutput> IO_CACHE = new ConcurrentHashMap<DefaultPraxisProject, InputOutput>();
    private static final String LISTENING_STATUS = "Listening at : ";
    private final DefaultPraxisProject project;

    ChildLauncherImpl(DefaultPraxisProject project) {
        this.project = Objects.requireNonNull(project);
    }

    public ChildLauncher.Info launch(List<String> javaOptions, List<String> arguments) throws Exception {
        String name = this.project.getProjectDirectory().getName();
        File launcher = CORE.launcherFile().toFile();
        CompletableFuture socketFuture = new CompletableFuture();
        StopAction stopAction = new StopAction(this.project);
        IO_CACHE.entrySet().removeIf(e -> ((InputOutput)e.getValue()).isClosed());
        InputOutput io = IO_CACHE.get(this.project);
        if (io != null) {
            io.closeInputOutput();
        }
        io = IOProvider.getDefault().getIO(name, true, new Action[]{stopAction}, null);
        IO_CACHE.put(this.project, io);
        ExecutionDescriptor desc = new ExecutionDescriptor().frontWindow(true).inputVisible(true).inputOutput(io).outProcessorFactory(defaultProcessor -> InputProcessors.proxy((InputProcessor[])new InputProcessor[]{InputProcessors.bridge((LineProcessor)new PortLineProcessor(socketFuture)), defaultProcessor})).preExecution(() -> EventQueue.invokeLater(() -> stopAction.setEnabled(true))).postExecution(() -> EventQueue.invokeLater(() -> stopAction.setEnabled(false)));
        ProcessBuilder pb = ProcessBuilder.getLocal();
        pb.setExecutable(launcher.getCanonicalPath());
        pb.setArguments(List.of("--port", "auto", "--interactive"));
        Environment env = pb.getEnvironment();
        env.setVariable("JAVA_HOME", System.getProperty("java.home"));
        env.setVariable("JAVA_OPTS", ((PArray)javaOptions.stream().map(PString::of).collect(PArray.collector())).toString());
        CompletableFuture processFuture = new CompletableFuture();
        ExecutionService exec = ExecutionService.newService(() -> {
            Process process = pb.call();
            processFuture.complete(process);
            return process;
        }, (ExecutionDescriptor)desc, (String)name);
        exec.run();
        return new ChildLauncher.Info((Process)processFuture.get(30L, TimeUnit.SECONDS), (SocketAddress)socketFuture.get(30L, TimeUnit.SECONDS));
    }

    private static SocketAddress parseListeningLine(String line) {
        if (line.startsWith(LISTENING_STATUS)) {
            try {
                int port = Integer.parseInt(line.substring(LISTENING_STATUS.length()).trim());
                return new InetSocketAddress(InetAddress.getLoopbackAddress(), port);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(ex);
            }
        }
        throw new IllegalArgumentException();
    }

    private static class StopAction
    extends AbstractAction {
        private final DefaultPraxisProject project;

        private StopAction(DefaultPraxisProject project) {
            super(Bundle.TXT_StopExecution(), ImageUtilities.loadImageIcon((String)"org/praxislive/ide/project/resources/stop.png", (boolean)true));
            this.project = project;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.project.clean();
        }
    }

    private static class PortLineProcessor
    implements LineProcessor {
        private final CompletableFuture<SocketAddress> socketFuture;

        private PortLineProcessor(CompletableFuture<SocketAddress> socketFuture) {
            this.socketFuture = socketFuture;
        }

        public void processLine(String line) {
            if (this.socketFuture.isDone()) {
                return;
            }
            if (line.startsWith(ChildLauncherImpl.LISTENING_STATUS)) {
                try {
                    this.socketFuture.complete(ChildLauncherImpl.parseListeningLine(line));
                }
                catch (Exception ex) {
                    this.socketFuture.completeExceptionally(ex);
                }
            }
        }

        public void reset() {
        }

        public void close() {
            if (!this.socketFuture.isDone()) {
                this.socketFuture.cancel(true);
            }
        }
    }
}

