/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.project;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.praxislive.ide.core.embedder.CORE;

public class CoreClassPathRegistry {
    private static final System.Logger LOG = System.getLogger(CoreClassPathRegistry.class.getName());
    private static final CoreClassPathRegistry INSTANCE = new CoreClassPathRegistry();
    private ClassPath classPath;
    private ClassPath bootClassPath;

    private CoreClassPathRegistry() {
        this.init();
    }

    private void init() {
        LOG.log(System.Logger.Level.DEBUG, "Initializing compile classpath");
        try {
            File modDir = CORE.modulesDir().toFile();
            ArrayList<URL> jars = new ArrayList<URL>();
            for (File jar : modDir.listFiles()) {
                if (!jar.getName().endsWith(".jar")) continue;
                URL jarURL = FileUtil.urlForArchiveOrDir((File)jar);
                LOG.log(System.Logger.Level.DEBUG, "Adding {0} to compile classpath", jarURL);
                jars.add(jarURL);
            }
            this.classPath = ClassPathSupport.createClassPath((URL[])jars.toArray(new URL[jars.size()]));
            GlobalPathRegistry.getDefault().register("classpath/compile", new ClassPath[]{this.classPath});
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            this.classPath = ClassPath.EMPTY;
        }
        this.bootClassPath = JavaPlatform.getDefault().getBootstrapLibraries();
        GlobalPathRegistry.getDefault().register("classpath/boot", new ClassPath[]{this.bootClassPath});
    }

    ClassPath getCompileClasspath() {
        return this.classPath;
    }

    ClassPath getBootClasspath() {
        return this.bootClassPath;
    }

    static CoreClassPathRegistry getInstance() {
        return INSTANCE;
    }

    public static class Initializer
    implements Runnable {
        @Override
        public void run() {
            CoreClassPathRegistry.getInstance();
        }
    }
}

