/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.lang.model.SourceVersion;
import javax.swing.Icon;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.ProjectState;
import org.netbeans.spi.project.support.LookupProviderSupport;
import org.netbeans.spi.project.ui.PrivilegedTemplates;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.netbeans.spi.project.ui.support.UILookupMergerSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.praxislive.core.Value;
import org.praxislive.core.types.PArray;
import org.praxislive.core.types.PResource;
import org.praxislive.ide.core.api.AbstractTask;
import org.praxislive.ide.core.api.Callback;
import org.praxislive.ide.core.api.SerialTasks;
import org.praxislive.ide.core.api.Task;
import org.praxislive.ide.project.Bundle;
import org.praxislive.ide.project.CoreClassPathRegistry;
import org.praxislive.ide.project.ExecutionEntry;
import org.praxislive.ide.project.HubManager;
import org.praxislive.ide.project.ProjectPropertiesImpl;
import org.praxislive.ide.project.api.ExecutionElement;
import org.praxislive.ide.project.api.ExecutionLevel;
import org.praxislive.ide.project.api.PraxisProject;
import org.praxislive.ide.project.spi.ElementHandler;
import org.praxislive.ide.project.spi.LineHandler;
import org.praxislive.ide.project.ui.PraxisCustomizerProvider;
import org.praxislive.ide.project.ui.PraxisLogicalViewProvider;
import org.praxislive.ide.project.ui.ProjectDialogManager;
import org.praxislive.project.ProjectElement;
import org.praxislive.project.ProjectModel;

public class DefaultPraxisProject
implements PraxisProject {
    public static final String LIBS_PATH = "config/libs/";
    static final String LIBS_COMMAND = "libraries {\n  config/libs/*.jar\n}";
    public static final int MIN_JAVA_VERSION = 21;
    public static final int MAX_JAVA_VERSION;
    private static final RequestProcessor RP;
    private static final LinkedHashSet<DefaultPraxisProject> REGISTRY;
    private final FileObject directory;
    private final FileObject projectFile;
    private final ProjectState state;
    private final HubManager hubManager;
    private final ProjectPropertiesImpl properties;
    private final PropertiesListener propsListener;
    private final Lookup lookup;
    private final Set<ElementHandler> executedHandlers;
    private boolean actionsEnabled;
    private List<URI> libPath;
    private ClassPath libsCP;
    private ClassPath compileCP;
    private TaskExec activeExec;

    DefaultPraxisProject(FileObject directory, FileObject projectFile, ProjectState state) throws IOException {
        this.directory = directory;
        this.projectFile = projectFile;
        this.state = state;
        this.hubManager = new HubManager(this);
        this.properties = this.parseProjectFile(projectFile);
        this.propsListener = new PropertiesListener();
        this.properties.addPropertyChangeListener(this.propsListener);
        Lookup base = Lookups.fixed((Object[])new Object[]{this, this.properties, new Info(), new ActionImpl(), new ProjectOpenedHookImpl(), state, new PraxisCustomizerProvider(this), new PraxisLogicalViewProvider(this), new BaseTemplates(this), new ClassPathImpl(), UILookupMergerSupport.createPrivilegedTemplatesMerger()});
        base = new ProxyLookup(new Lookup[]{base, this.hubManager.getLookup()});
        this.lookup = LookupProviderSupport.createCompositeLookup((Lookup)base, (String)"Projects/org-praxislive-ide-project/Lookup");
        this.executedHandlers = new HashSet<ElementHandler>();
        this.actionsEnabled = true;
        this.libPath = List.of();
        this.compileCP = CoreClassPathRegistry.getInstance().getCompileClasspath();
    }

    private ProjectPropertiesImpl parseProjectFile(FileObject projectFile) {
        ProjectPropertiesImpl props = new ProjectPropertiesImpl(this);
        try {
            ProjectModel model = ProjectModel.parse((URI)this.directory.toURI(), (String)projectFile.asText());
            List<ExecutionElement> config = model.setupElements().stream().map(this::fromModelElement).filter(e -> e != null).toList();
            List<ExecutionElement> build = model.buildElements().stream().map(this::fromModelElement).filter(e -> e != null).toList();
            List<ExecutionElement> run = model.runElements().stream().map(this::fromModelElement).filter(e -> e != null).toList();
            props.initElements(Map.of(ExecutionLevel.CONFIGURE, config, ExecutionLevel.BUILD, build, ExecutionLevel.RUN, run));
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return props;
    }

    public FileObject getProjectDirectory() {
        return this.directory;
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public void save() throws IOException {
        ProjectModel.Builder builder = ProjectModel.builder();
        builder.context(this.directory.toURI());
        Map<ExecutionLevel, List<ExecutionEntry>> elements = this.properties.elements();
        elements.get((Object)ExecutionLevel.CONFIGURE).forEach(e -> builder.setupElement(this.toModelElement((ExecutionEntry)e)));
        elements.get((Object)ExecutionLevel.BUILD).forEach(e -> builder.buildElement(this.toModelElement((ExecutionEntry)e)));
        elements.get((Object)ExecutionLevel.RUN).forEach(e -> builder.runElement(this.toModelElement((ExecutionEntry)e)));
        String script = builder.build().writeToString();
        Files.writeString(FileUtil.toPath((FileObject)this.projectFile), (CharSequence)script, new OpenOption[0]);
    }

    public boolean isActive() {
        return this.hubManager.getState() == HubManager.State.Running;
    }

    public static List<DefaultPraxisProject> activeProjects() {
        REGISTRY.removeIf(p -> !p.isActive());
        return new ArrayList<DefaultPraxisProject>(REGISTRY);
    }

    private void execute(ExecutionLevel level) {
        if (this.properties.getJavaRelease() > MAX_JAVA_VERSION) {
            ProjectDialogManager.get(this).reportError(Bundle.PraxisProject_javaVersionError(this.properties.getJavaRelease()));
            return;
        }
        ArrayList<Task> tasks = new ArrayList<Task>();
        if (!this.isActive()) {
            this.executedHandlers.clear();
            tasks.add(this.hubManager.createStartupTask());
        }
        Map<ExecutionLevel, List<ExecutionEntry>> elements = this.properties.elements();
        elements.get((Object)ExecutionLevel.CONFIGURE).forEach(e -> {
            if (!this.executedHandlers.contains(e.handler())) {
                tasks.add((Task)new ElementTask(ExecutionLevel.CONFIGURE, (ExecutionEntry)e));
            }
        });
        if (level == ExecutionLevel.BUILD || level == ExecutionLevel.RUN) {
            elements.get((Object)ExecutionLevel.BUILD).forEach(e -> {
                if (!this.executedHandlers.contains(e.handler())) {
                    tasks.add((Task)new ElementTask(ExecutionLevel.BUILD, (ExecutionEntry)e));
                }
            });
        }
        if (level == ExecutionLevel.RUN) {
            elements.get((Object)ExecutionLevel.RUN).forEach(e -> tasks.add((Task)new ElementTask(ExecutionLevel.RUN, (ExecutionEntry)e)));
        }
        this.actionsEnabled = false;
        this.activeExec = new TaskExec(tasks);
        Task.State execState = this.activeExec.execute();
        if (execState == Task.State.RUNNING) {
            this.activeExec.addPropertyChangeListener(e -> {
                this.actionsEnabled = true;
                this.activeExec = null;
                if (this.isActive()) {
                    REGISTRY.add(this);
                }
            });
        } else {
            this.actionsEnabled = true;
            this.activeExec = null;
            if (this.isActive()) {
                REGISTRY.add(this);
            }
        }
    }

    void clean() {
        if (this.activeExec != null) {
            this.activeExec.cancel();
        }
        List<Task> tasks = List.of(this.hubManager.createShutdownTask());
        this.activeExec = new TaskExec(tasks);
        this.actionsEnabled = false;
        Task.State execState = this.activeExec.execute();
        if (execState == Task.State.RUNNING) {
            this.activeExec.addPropertyChangeListener(e -> {
                this.actionsEnabled = true;
                this.activeExec = null;
                REGISTRY.removeIf(p -> !p.isActive());
            });
        } else {
            this.actionsEnabled = true;
            this.activeExec = null;
            REGISTRY.removeIf(p -> !p.isActive());
        }
    }

    void updateLibs(PArray newLibs, PArray newLibsPath) {
        this.clearLibs();
        this.properties.updateLibraries(newLibs);
        this.libPath = List.copyOf(this.buildLibList(newLibsPath));
        this.libsCP = this.buildLibsClasspath(this.libPath);
        if (this.libsCP != null) {
            this.compileCP = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{this.libsCP, CoreClassPathRegistry.getInstance().getCompileClasspath()});
            GlobalPathRegistry.getDefault().register("classpath/compile", new ClassPath[]{this.libsCP});
        }
    }

    private void clearLibs() {
        if (this.libsCP != null) {
            GlobalPathRegistry.getDefault().unregister("classpath/compile", new ClassPath[]{this.libsCP});
        }
        this.libPath = List.of();
        this.libsCP = null;
        this.compileCP = CoreClassPathRegistry.getInstance().getCompileClasspath();
    }

    private List<URI> buildLibList(PArray path) {
        return path.stream().flatMap(v -> PResource.from((Value)v).stream()).map(PResource::value).filter(uri -> "file".equals(uri.getScheme())).collect(Collectors.toList());
    }

    private ClassPath buildLibsClasspath(List<URI> path) {
        try {
            return ClassPathSupport.createClassPath((URL[])((URL[])path.stream().map(File::new).map(FileUtil::urlForArchiveOrDir).toArray(URL[]::new)));
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    private ExecutionElement fromModelElement(ProjectElement element) {
        try {
            if (element instanceof ProjectElement.File) {
                ProjectElement.File fileElement = (ProjectElement.File)element;
                return ExecutionElement.forFile(FileUtil.toFileObject((Path)Path.of(fileElement.file())));
            }
            if (element instanceof ProjectElement.Line) {
                ProjectElement.Line lineElement = (ProjectElement.Line)element;
                return ExecutionElement.forLine(lineElement.line());
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return null;
    }

    private ProjectElement toModelElement(ExecutionEntry entry) {
        ExecutionElement element = entry.element();
        ElementHandler handler = entry.handler();
        if (element instanceof ExecutionElement.File) {
            ExecutionElement.File fileElement = (ExecutionElement.File)element;
            return ProjectElement.file((URI)fileElement.file().toURI());
        }
        if (element instanceof ExecutionElement.Line) {
            ExecutionElement.Line lineElement = (ExecutionElement.Line)element;
            String line = lineElement.line();
            if (handler instanceof LineHandler) {
                LineHandler lineHandler = (LineHandler)handler;
                line = lineHandler.rewrite(line);
            }
            return ProjectElement.line((String)line);
        }
        throw new IllegalArgumentException();
    }

    static {
        int max = SourceVersion.latest().ordinal();
        MAX_JAVA_VERSION = max < 21 ? 21 : max;
        RP = new RequestProcessor(PraxisProject.class);
        REGISTRY = new LinkedHashSet();
    }

    private class PropertiesListener
    implements PropertyChangeListener {
        private PropertiesListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            DefaultPraxisProject.this.state.markModified();
            RP.schedule(new Runnable(){

                @Override
                public void run() {
                    try {
                        ProjectManager.getDefault().saveProject((Project)DefaultPraxisProject.this);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }, 500L, TimeUnit.MILLISECONDS);
        }
    }

    private class Info
    implements ProjectInformation {
        private Info() {
        }

        public String getName() {
            return DefaultPraxisProject.this.directory.getName();
        }

        public String getDisplayName() {
            return DefaultPraxisProject.this.directory.getName();
        }

        public Icon getIcon() {
            return ImageUtilities.loadImageIcon((String)"org/praxislive/ide/project/resources/pxp16.png", (boolean)false);
        }

        public Project getProject() {
            return DefaultPraxisProject.this;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
        }
    }

    private class ActionImpl
    implements ActionProvider {
        private ActionImpl() {
        }

        public String[] getSupportedActions() {
            return new String[]{"run", "build", "clean"};
        }

        public void invokeAction(String command, Lookup context) throws IllegalArgumentException {
            if ("run".equals(command)) {
                DefaultPraxisProject.this.execute(ExecutionLevel.RUN);
            } else if ("build".equals(command)) {
                DefaultPraxisProject.this.execute(ExecutionLevel.BUILD);
            } else if ("clean".equals(command)) {
                DefaultPraxisProject.this.clean();
            } else {
                throw new IllegalArgumentException();
            }
        }

        public boolean isActionEnabled(String command, Lookup context) throws IllegalArgumentException {
            if ("clean".equals(command)) {
                return DefaultPraxisProject.this.isActive();
            }
            return DefaultPraxisProject.this.actionsEnabled;
        }
    }

    private class ProjectOpenedHookImpl
    extends ProjectOpenedHook {
        private ProjectOpenedHookImpl() {
        }

        protected void projectOpened() {
        }

        protected void projectClosed() {
            DefaultPraxisProject.this.clearLibs();
        }
    }

    private class BaseTemplates
    implements PrivilegedTemplates {
        private BaseTemplates(DefaultPraxisProject defaultPraxisProject) {
        }

        public String[] getPrivilegedTemplates() {
            return new String[]{"Templates/Other/Folder", "Templates/Other/org-netbeans-modules-project-ui-NewFileIterator-folderIterator"};
        }
    }

    private class ClassPathImpl
    implements ClassPathProvider {
        private ClassPathImpl() {
        }

        public ClassPath findClassPath(FileObject file, String type) {
            switch (type) {
                case "classpath/boot": 
                case "modules/boot": {
                    return CoreClassPathRegistry.getInstance().getBootClasspath();
                }
                case "classpath/compile": {
                    return DefaultPraxisProject.this.compileCP;
                }
            }
            return null;
        }
    }

    private class TaskExec
    extends SerialTasks {
        private final Map<Task, List<String>> warnings;
        private final ProgressHandle progress;
        private final int count;

        private TaskExec(List<Task> tasks) {
            super(tasks);
            this.warnings = new LinkedHashMap<Task, List<String>>();
            this.progress = ProgressHandle.createHandle((String)"Executing...", (Cancellable)this);
            this.progress.setInitialDelay(0);
            this.count = tasks.size();
        }

        protected void beforeExecute() {
            this.progress.start(this.count);
        }

        protected void beforeTask(Task task) {
            task.description().ifPresentOrElse(d -> this.progress.progress(d, this.count - this.remaining()), () -> this.progress.progress(this.count - this.remaining()));
        }

        protected void afterTask(Task task) {
            List log = task.log();
            if (!log.isEmpty()) {
                this.warnings.put(task, List.copyOf(log));
            }
        }

        protected void afterExecute() {
            this.progress.finish();
            if (!this.warnings.isEmpty()) {
                ProjectDialogManager.get(DefaultPraxisProject.this).reportWarnings(this.warnings);
            }
        }
    }

    private class ElementTask
    extends AbstractTask {
        private final ExecutionLevel level;
        private final ExecutionElement element;
        private final ElementHandler handler;

        private ElementTask(ExecutionLevel level, ExecutionEntry entry) {
            this.level = level;
            this.element = entry.element();
            this.handler = entry.handler();
        }

        protected void handleExecute() throws Exception {
            if (this.level != ExecutionLevel.RUN) {
                DefaultPraxisProject.this.executedHandlers.add(this.handler);
            }
            this.handler.process(Callback.create(result -> {
                if (result.isError()) {
                    if (this.continueOnError(result.args())) {
                        this.updateState(Task.State.COMPLETED);
                    } else {
                        this.updateState(Task.State.ERROR);
                    }
                } else {
                    this.updateState(Task.State.COMPLETED);
                }
            }));
        }

        public Optional<String> description() {
            if (this.element instanceof ExecutionElement.File) {
                String msg = FileUtil.getRelativePath((FileObject)DefaultPraxisProject.this.getProjectDirectory(), (FileObject)((ExecutionElement.File)this.element).file()) + " [" + String.valueOf((Object)this.level) + "]";
                return Optional.of(msg);
            }
            return Optional.empty();
        }

        public List<String> log() {
            return this.handler.warnings();
        }

        private boolean continueOnError(List<Value> args) {
            String pathOrCmd;
            if (this.element instanceof ExecutionElement.File) {
                FileObject file = ((ExecutionElement.File)this.element).file();
                String path = FileUtil.getRelativePath((FileObject)DefaultPraxisProject.this.getProjectDirectory(), (FileObject)file);
                if (path == null) {
                    path = file.getPath();
                }
                pathOrCmd = path;
            } else if (this.element instanceof ExecutionElement.Line) {
                String cmd = ((ExecutionElement.Line)this.element).line();
                if (this.handler instanceof LineHandler) {
                    cmd = ((LineHandler)this.handler).rewrite(cmd).lines().limit(5L).collect(Collectors.joining("\n"));
                }
                pathOrCmd = cmd;
            } else {
                pathOrCmd = "???";
            }
            String extra = null;
            if (!args.isEmpty()) {
                extra = args.get(0).toString().lines().limit(5L).collect(Collectors.joining("\n"));
            }
            Object message = Bundle.ERR_elementExecution(pathOrCmd);
            if (extra != null) {
                message = (String)message + "\n\n";
                message = (String)message + extra;
            }
            String title = this.level == ExecutionLevel.RUN ? Bundle.ERR_elementContinueRun() : Bundle.ERR_elementContinueBuild();
            return ProjectDialogManager.get(DefaultPraxisProject.this).confirmOnError(title, (String)message);
        }
    }
}

