/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.project;

import java.awt.EventQueue;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.Timer;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.praxislive.core.ComponentType;
import org.praxislive.core.MainThread;
import org.praxislive.core.Root;
import org.praxislive.core.services.LogLevel;
import org.praxislive.core.services.RootManagerService;
import org.praxislive.core.services.ScriptService;
import org.praxislive.core.services.Service;
import org.praxislive.core.services.SystemManagerService;
import org.praxislive.hub.Hub;
import org.praxislive.hub.net.ChildLauncher;
import org.praxislive.hub.net.HubConfiguration;
import org.praxislive.hub.net.NetworkCoreFactory;
import org.praxislive.hub.net.ProxyInfo;
import org.praxislive.ide.core.api.AbstractTask;
import org.praxislive.ide.core.api.ExtensionContainer;
import org.praxislive.ide.core.api.Logging;
import org.praxislive.ide.core.api.SerialTasks;
import org.praxislive.ide.core.api.Task;
import org.praxislive.ide.project.ChildLauncherImpl;
import org.praxislive.ide.project.DefaultPraxisProject;
import org.praxislive.ide.project.HubProxyImpl;
import org.praxislive.ide.project.LocalComponents;
import org.praxislive.ide.project.ProjectHelper;
import org.praxislive.ide.project.ServicesOverride;
import org.praxislive.ide.project.spi.RootLifecycleHandler;

class HubManager {
    private static final Logger LOG = Logger.getLogger(HubManager.class.getName());
    private final DefaultPraxisProject project;
    private final HubProxyImpl proxy;
    private final Lookup lookup;
    private final InstanceContent lookupContent;
    private Hub hub;
    private ExtensionContainer container;
    private State state;
    private ServicesOverride servicesOverride;

    HubManager(DefaultPraxisProject project) {
        this.project = project;
        this.proxy = new HubProxyImpl(project);
        this.state = State.Stopped;
        this.lookupContent = new InstanceContent();
        this.lookupContent.add((Object)this.proxy);
        this.lookupContent.add((Object)LocalComponents.getInstance());
        this.lookup = new AbstractLookup((AbstractLookup.Content)this.lookupContent);
    }

    Task createStartupTask() {
        return new StartUpTask(List.of(new InitHubTask()));
    }

    Task createShutdownTask() {
        Set<String> roots = this.servicesOverride.getKnownUserRoots();
        String description = "Shutdown";
        ArrayList tasks = this.project.getLookup().lookupAll(RootLifecycleHandler.class).stream().flatMap(handler -> handler.getDeletionTask(description, roots).stream()).collect(Collectors.toCollection(ArrayList::new));
        tasks.add(new DeinitHubTask());
        return new ShutDownTask(tasks);
    }

    State getState() {
        return this.state;
    }

    Lookup getLookup() {
        return this.lookup;
    }

    private void initHub() throws Exception {
        if (this.hub != null) {
            throw new IllegalStateException();
        }
        this.container = ExtensionContainer.create((Lookup)this.project.getLookup());
        this.container.extensions().forEach(arg_0 -> ((InstanceContent)this.lookupContent).add(arg_0));
        this.servicesOverride = new ServicesOverride(this.project);
        Logging log = Logging.create((Lookup)this.project.getLookup());
        LogLevel logLevel = log.getLogLevel();
        NetworkCoreFactory core = NetworkCoreFactory.builder().childLauncher((ChildLauncher)new ChildLauncherImpl(this.project)).exposeServices(List.of(RootManagerService.class, SystemManagerService.class)).hubConfiguration(HubConfiguration.builder().proxy((ProxyInfo)new Proxy()).build()).build();
        FakeMain fakeMain = new FakeMain();
        this.hub = Hub.builder().setCoreRootFactory((Hub.CoreRootFactory)core).addExtension((Root)this.servicesOverride).addExtension((Root)log).addExtension((Root)this.container).extendLookup((Object)logLevel).extendLookup((Object)fakeMain).build();
        this.hub.start();
    }

    private void deinitHub() {
        this.container.extensions().forEach(arg_0 -> ((InstanceContent)this.lookupContent).remove(arg_0));
        this.hub.shutdown();
        try {
            this.hub.await();
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.container = null;
        this.servicesOverride = null;
        this.hub = null;
    }

    static enum State {
        Stopped,
        Starting,
        Running,
        Stopping;

    }

    private class StartUpTask
    extends SerialTasks {
        public StartUpTask(List<Task> tasks) {
            super(tasks);
        }

        public Optional<String> description() {
            return Optional.of("Initializing hub.");
        }

        protected void beforeExecute() {
            if (HubManager.this.state != State.Stopped) {
                throw new IllegalStateException();
            }
            HubManager.this.state = State.Starting;
        }

        protected void afterExecute() {
            if (HubManager.this.hub != null && HubManager.this.hub.isAlive()) {
                HubManager.this.state = State.Running;
                HubManager.this.proxy.start();
            } else {
                HubManager.this.state = State.Stopped;
            }
        }
    }

    private class InitHubTask
    extends AbstractTask {
        private ProjectHelper helper;
        private int count;
        private Timer timer;

        private InitHubTask() {
        }

        protected void handleExecute() throws Exception {
            HubManager.this.initHub();
            this.helper = (ProjectHelper)((Object)HubManager.this.lookup.lookup(ProjectHelper.class));
            if (this.helper == null) {
                this.updateState(Task.State.ERROR);
            } else {
                this.timer = new Timer(50, e -> this.checkHelper());
                this.timer.start();
                this.updateState(Task.State.RUNNING);
            }
        }

        private void checkHelper() {
            if (this.helper.isConnected()) {
                this.timer.stop();
                this.updateState(Task.State.COMPLETED);
            } else if (this.count++ > 10) {
                this.timer.stop();
                this.updateState(Task.State.ERROR);
            }
        }
    }

    private class DeinitHubTask
    extends AbstractTask {
        private DeinitHubTask() {
        }

        protected void handleExecute() throws Exception {
            try {
                HubManager.this.proxy.stop();
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            HubManager.this.deinitHub();
            this.updateState(Task.State.COMPLETED);
        }
    }

    private class ShutDownTask
    extends SerialTasks {
        public ShutDownTask(List<Task> tasks) {
            super(tasks);
        }

        protected void beforeExecute() {
            if (HubManager.this.state != State.Running) {
                throw new IllegalStateException();
            }
            HubManager.this.state = State.Stopping;
        }

        protected void afterExecute() {
            HubManager.this.state = HubManager.this.hub != null && HubManager.this.hub.isAlive() ? State.Running : State.Stopped;
        }
    }

    private static class Proxy
    implements ProxyInfo {
        private Proxy() {
        }

        public Optional<ProxyInfo.Exec> exec() {
            return Optional.of(new ProxyInfo.Exec(this){});
        }

        public boolean matches(String string, ComponentType ct) {
            return !ct.toString().equals("root:gui");
        }

        public List<Class<? extends Service>> services() {
            return List.of(ScriptService.class);
        }

        public SocketAddress socketAddress() {
            return new InetSocketAddress(InetAddress.getLoopbackAddress(), 0);
        }
    }

    private static class FakeMain
    implements MainThread {
        private FakeMain() {
        }

        public void runLater(Runnable task) {
            EventQueue.invokeLater(task);
        }

        public boolean isMainThread() {
            return EventQueue.isDispatchThread();
        }
    }
}

