/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.project;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Action;
import javax.swing.Timer;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.praxislive.base.Binding;
import org.praxislive.core.ComponentAddress;
import org.praxislive.core.ComponentInfo;
import org.praxislive.core.ComponentType;
import org.praxislive.core.ControlAddress;
import org.praxislive.core.Info;
import org.praxislive.core.Value;
import org.praxislive.core.services.RootManagerService;
import org.praxislive.core.types.PArray;
import org.praxislive.ide.core.api.ValuePropertyAdaptor;
import org.praxislive.ide.model.HubProxy;
import org.praxislive.ide.model.RootProxy;
import org.praxislive.ide.project.DefaultPraxisProject;
import org.praxislive.ide.project.ProjectHelper;
import org.praxislive.ide.project.spi.RootRegistry;
import org.praxislive.ide.properties.PraxisProperty;

class HubProxyImpl
implements HubProxy {
    private final DefaultPraxisProject project;
    private final ValuePropertyAdaptor.ReadOnly rootsAdaptor;
    private final RootsChildren rootsChildren;
    private final Node hubNode;
    private final PropertyChangeSupport pcs;
    private final Map<String, RootProxy> roots;
    private final List<RootRegistry> rootRegistries;
    private final PropertyChangeListener regListener;
    private boolean ignoreChanges;
    private PArray libs;
    private Timer libsTimer;

    HubProxyImpl(DefaultPraxisProject project) {
        this.project = project;
        this.rootsAdaptor = new ValuePropertyAdaptor.ReadOnly((Object)this, "roots", true, Binding.SyncRate.Low);
        this.rootsAdaptor.addPropertyChangeListener(e -> this.refreshRoots());
        this.regListener = e -> this.refreshProxies();
        this.rootsChildren = new RootsChildren();
        this.hubNode = new HubNode(this, (Children)this.rootsChildren);
        this.pcs = new PropertyChangeSupport(this);
        this.roots = new LinkedHashMap<String, RootProxy>();
        this.rootRegistries = new ArrayList<RootRegistry>();
        this.libs = PArray.EMPTY;
    }

    public RootProxy getRoot(String id) {
        return this.roots.get(id);
    }

    public Stream<String> roots() {
        return this.roots.keySet().stream();
    }

    public Node getNodeDelegate() {
        return this.hubNode;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public Lookup getLookup() {
        return Lookup.EMPTY;
    }

    void start() {
        ProjectHelper helper = (ProjectHelper)((Object)this.project.getLookup().lookup(ProjectHelper.class));
        try {
            ControlAddress address = ControlAddress.of((ComponentAddress)helper.findService(RootManagerService.class), (String)"roots");
            helper.bind(address, (Binding.Adaptor)this.rootsAdaptor);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.libsTimer = new Timer(10, e -> helper.execScript("libraries").thenCompose(libArgs -> {
            PArray newLibs = PArray.from((Value)((Value)libArgs.get(0))).orElse(PArray.EMPTY);
            if (!Objects.equals(this.libs, newLibs)) {
                this.libs = newLibs;
                return helper.execScript("libraries-path").thenAccept(pathArgs -> {
                    PArray newPath = PArray.from((Value)((Value)pathArgs.get(0))).orElse(PArray.EMPTY);
                    this.project.updateLibs(newLibs, newPath);
                });
            }
            return CompletableFuture.completedStage(null);
        }));
        this.libsTimer.setDelay(1000);
        this.libsTimer.start();
        this.project.getLookup().lookupAll(RootRegistry.class).forEach(r -> {
            if (this.rootRegistries.add((RootRegistry)r)) {
                r.addPropertyChangeListener(this.regListener);
            }
        });
        this.ignoreChanges = false;
    }

    void stop() {
        this.ignoreChanges = true;
        ProjectHelper helper = (ProjectHelper)((Object)this.project.getLookup().lookup(ProjectHelper.class));
        try {
            ControlAddress address = ControlAddress.of((ComponentAddress)helper.findService(RootManagerService.class), (String)"roots");
            helper.unbind(address, (Binding.Adaptor)this.rootsAdaptor);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (this.libsTimer != null) {
            this.libsTimer.stop();
            this.libsTimer = null;
        }
        this.rootsAdaptor.removePropertyChangeListener(this.regListener);
        this.rootRegistries.forEach(r -> r.removePropertyChangeListener(this.regListener));
        this.rootRegistries.clear();
        this.roots.forEach((id, proxy) -> {
            if (proxy instanceof AutoCloseable) {
                try {
                    ((AutoCloseable)proxy).close();
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
        this.roots.clear();
        this.rootsChildren.refreshRoots();
        this.pcs.firePropertyChange("roots", null, null);
        this.ignoreChanges = false;
    }

    private void refreshRoots() {
        if (this.ignoreChanges) {
            return;
        }
        this.ignoreChanges = true;
        List<String> rts = PArray.from((Value)this.rootsAdaptor.getValue()).orElse(PArray.EMPTY).stream().map(Value::toString).collect(Collectors.toList());
        this.roots.forEach((id, proxy) -> {
            if (!rts.contains(id) && proxy instanceof AutoCloseable) {
                try {
                    ((AutoCloseable)proxy).close();
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
        this.roots.keySet().retainAll(rts);
        rts.forEach(r -> this.roots.compute((String)r, this::findRootProxy));
        this.rootsChildren.refreshRoots();
        this.pcs.firePropertyChange("roots", null, null);
        this.ignoreChanges = false;
    }

    private void refreshProxies() {
        if (this.ignoreChanges) {
            return;
        }
        this.ignoreChanges = true;
        this.roots.replaceAll(this::findRootProxy);
        this.rootsChildren.refreshRoots();
        this.pcs.firePropertyChange("roots", null, null);
        this.ignoreChanges = false;
    }

    private RootProxy findRootProxy(String id, RootProxy existing) {
        RootProxy proxy = this.project.getLookup().lookupAll(RootRegistry.class).stream().flatMap(reg -> reg.find(id).stream()).findFirst().orElseGet(() -> existing instanceof FallbackRootProxy ? existing : new FallbackRootProxy(this, id));
        if (proxy != existing && existing instanceof AutoCloseable) {
            try {
                ((AutoCloseable)existing).close();
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return proxy;
    }

    private class RootsChildren
    extends Children.Keys<RootProxy> {
        private RootsChildren() {
        }

        protected Node[] createNodes(RootProxy key) {
            return new Node[]{key.getNodeDelegate()};
        }

        private void refreshRoots() {
            this.setKeys(HubProxyImpl.this.roots.values());
        }
    }

    private class HubNode
    extends AbstractNode {
        private HubNode(HubProxyImpl hubProxyImpl, Children children) {
            super(children);
        }

        public Action[] getActions(boolean context) {
            return new Action[0];
        }
    }

    private class FallbackRootProxy
    implements RootProxy {
        private final ComponentAddress address;
        private final Node node;

        private FallbackRootProxy(HubProxyImpl hubProxyImpl, String id) {
            this.address = ComponentAddress.of((String)("/" + id));
            this.node = new FallbackRootNode(hubProxyImpl, this);
        }

        public ComponentAddress getAddress() {
            return this.address;
        }

        public ComponentType getType() {
            return ComponentType.of((String)"root:unknown");
        }

        public ComponentInfo getInfo() {
            return Info.component(c -> c);
        }

        public CompletionStage<List<Value>> send(String control, List<Value> args) {
            throw new UnsupportedOperationException();
        }

        public Node getNodeDelegate() {
            return this.node;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
        }

        public Lookup getLookup() {
            return Lookup.EMPTY;
        }

        public PraxisProperty<?> getProperty(String id) {
            return null;
        }
    }

    private class FallbackRootNode
    extends AbstractNode {
        private final String name;

        private FallbackRootNode(HubProxyImpl hubProxyImpl, FallbackRootProxy proxy) {
            super(Children.LEAF, Lookups.singleton((Object)proxy));
            this.name = proxy.address.rootID();
            this.setExpert(true);
        }

        public String getName() {
            return this.name;
        }

        public Action[] getActions(boolean context) {
            return new Action[0];
        }
    }
}

