/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.project;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.praxislive.core.ComponentType;
import org.praxislive.core.services.ComponentFactoryProvider;
import org.praxislive.ide.components.api.Components;

class LocalComponents
implements Components {
    private static final LocalComponents INSTANCE = new LocalComponents();
    private final Map<ComponentType, Lookup> componentData = new LinkedHashMap<ComponentType, Lookup>();
    private final Map<ComponentType, Lookup> rootData = new LinkedHashMap<ComponentType, Lookup>();
    private final List<ComponentType> components;
    private final List<ComponentType> roots;

    private LocalComponents() {
        ArrayList cmps = new ArrayList();
        ArrayList rts = new ArrayList();
        Lookup.getDefault().lookupAll(ComponentFactoryProvider.class).stream().map(provider -> provider.getFactory()).forEachOrdered(factory -> {
            factory.componentTypes().forEachOrdered(type -> {
                cmps.add(type);
                this.componentData.put((ComponentType)type, Lookups.fixed((Object[])factory.componentData(type).findAll(Object.class).toArray()));
            });
            factory.rootTypes().forEachOrdered(type -> {
                rts.add(type);
                this.rootData.put((ComponentType)type, Lookups.fixed((Object[])factory.rootData(type).findAll(Object.class).toArray()));
            });
        });
        this.components = List.copyOf(cmps);
        this.roots = List.copyOf(rts);
    }

    public List<ComponentType> componentTypes() {
        return this.components;
    }

    public List<ComponentType> rootTypes() {
        return this.roots;
    }

    public Lookup metaData(ComponentType type) {
        Lookup data = this.componentData.get(type);
        if (data == null) {
            data = this.rootData.get(type);
        }
        return data;
    }

    static Components getInstance() {
        return INSTANCE;
    }
}

