/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.project;

import java.io.IOException;
import java.util.ArrayList;
import javax.swing.Icon;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.spi.project.ProjectFactory2;
import org.netbeans.spi.project.ProjectState;
import org.openide.filesystems.FileObject;
import org.openide.util.ImageUtilities;
import org.praxislive.ide.project.DefaultPraxisProject;

public class PraxisProjectFactory
implements ProjectFactory2 {
    private static final Icon icon = ImageUtilities.loadImageIcon((String)"org/praxislive/ide/project/resources/pxp16.png", (boolean)false);

    public boolean isProject(FileObject projectDirectory) {
        FileObject[] files;
        for (FileObject file : files = projectDirectory.getChildren()) {
            if (!file.hasExt("pxp")) continue;
            return true;
        }
        return false;
    }

    public ProjectManager.Result isProject2(FileObject projectDirectory) {
        if (this.isProject(projectDirectory)) {
            return new ProjectManager.Result(icon);
        }
        return null;
    }

    public Project loadProject(FileObject projectDirectory, ProjectState state) throws IOException {
        FileObject[] files;
        ArrayList<FileObject> possibles = new ArrayList<FileObject>(1);
        for (FileObject file : files = projectDirectory.getChildren()) {
            if (!file.hasExt("pxp")) continue;
            possibles.add(file);
        }
        if (possibles.isEmpty()) {
            return null;
        }
        if (possibles.size() != 1) {
            return null;
        }
        FileObject projectFile = (FileObject)possibles.get(0);
        return new DefaultPraxisProject(projectDirectory, projectFile, state);
    }

    public void saveProject(Project project) throws IOException, ClassCastException {
        DefaultPraxisProject p = (DefaultPraxisProject)project.getLookup().lookup(DefaultPraxisProject.class);
        if (p != null) {
            p.save();
        }
    }
}

