/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.project;

import java.awt.EventQueue;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.praxislive.core.Value;
import org.praxislive.core.syntax.Token;
import org.praxislive.core.types.PArray;
import org.praxislive.core.types.PMap;
import org.praxislive.core.types.PResource;
import org.praxislive.hub.net.HubConfiguration;
import org.praxislive.ide.core.api.Callback;
import org.praxislive.ide.project.Bundle;
import org.praxislive.ide.project.DefaultFileHandler;
import org.praxislive.ide.project.DefaultLineHandler;
import org.praxislive.ide.project.DefaultPraxisProject;
import org.praxislive.ide.project.ExecutionEntry;
import org.praxislive.ide.project.ProjectHelper;
import org.praxislive.ide.project.api.ExecutionElement;
import org.praxislive.ide.project.api.ExecutionLevel;
import org.praxislive.ide.project.api.PraxisProject;
import org.praxislive.ide.project.api.ProjectProperties;
import org.praxislive.ide.project.spi.ElementHandler;
import org.praxislive.ide.project.spi.FileHandler;
import org.praxislive.ide.project.spi.LineHandler;
import org.praxislive.ide.project.ui.ProjectDialogManager;
import org.praxislive.ide.properties.SyntaxUtils;

public class ProjectPropertiesImpl
implements ProjectProperties {
    private static final String DEFAULT_HUB_CONFIG;
    private final Map<ExecutionLevel, Map<ExecutionElement, ElementHandler>> elements;
    private final PropertyChangeSupport pcs;
    private final DefaultPraxisProject project;
    private final FileListener listener;
    private final HubLineHandler hubHandler;
    private final CompilerLineHandler compilerHandler;
    private final LibrariesLineHandler librariesHandler;
    private final List<URI> libraries;
    private final List<FileHandler.Provider> fileHandlerProviders;
    private final List<LineHandler.Provider> lineHandlerProviders;
    private int javaRelease = 21;

    ProjectPropertiesImpl(DefaultPraxisProject project) {
        this.project = project;
        this.elements = new EnumMap<ExecutionLevel, Map<ExecutionElement, ElementHandler>>(ExecutionLevel.class);
        for (ExecutionLevel level : ExecutionLevel.values()) {
            this.elements.put(level, new LinkedHashMap());
        }
        this.hubHandler = new HubLineHandler();
        this.compilerHandler = new CompilerLineHandler();
        this.librariesHandler = new LibrariesLineHandler();
        this.libraries = new ArrayList<URI>();
        this.fileHandlerProviders = new ArrayList<FileHandler.Provider>(Lookup.getDefault().lookupAll(FileHandler.Provider.class));
        this.lineHandlerProviders = new ArrayList<LineHandler.Provider>();
        this.lineHandlerProviders.add(this::findInternalHandler);
        this.lineHandlerProviders.addAll(Lookup.getDefault().lookupAll(LineHandler.Provider.class));
        this.pcs = new PropertyChangeSupport(this);
        this.listener = new FileListener();
        project.getProjectDirectory().addRecursiveListener((FileChangeListener)this.listener);
    }

    @Override
    public void setElements(ExecutionLevel level, List<ExecutionElement> elements) {
        if (level == ExecutionLevel.CONFIGURE) {
            throw new IllegalArgumentException("Changing configure level not currently supported");
        }
        HashSet<ElementHandler> handlers = new HashSet<ElementHandler>();
        if (level == ExecutionLevel.BUILD) {
            handlers.addAll(this.elements.get((Object)ExecutionLevel.CONFIGURE).values());
            handlers.addAll(this.elements.get((Object)ExecutionLevel.RUN).values());
        } else {
            handlers.addAll(this.elements.get((Object)ExecutionLevel.CONFIGURE).values());
            handlers.addAll(this.elements.get((Object)ExecutionLevel.BUILD).values());
        }
        Map<ExecutionElement, ElementHandler> existing = this.elements.get((Object)level);
        LinkedHashMap<ExecutionElement, ElementHandler> replacements = new LinkedHashMap<ExecutionElement, ElementHandler>(elements.size());
        for (ExecutionElement el : elements) {
            ElementHandler handler = existing.get(el);
            if (handler == null) {
                handler = this.findHandler(level, el);
            }
            if (!handlers.add(handler)) {
                throw new IllegalArgumentException("Duplicate handler");
            }
            replacements.put(el, handler);
        }
        existing.clear();
        existing.putAll(replacements);
        this.pcs.firePropertyChange("elements", null, null);
    }

    @Override
    public List<ExecutionElement> getElements(ExecutionLevel level) {
        return new ArrayList<ExecutionElement>(this.elements.get((Object)level).keySet());
    }

    @Override
    public PraxisProject getProject() {
        return this.project;
    }

    void initElements(Map<ExecutionLevel, List<ExecutionElement>> elementMap) {
        this.initConfigure(elementMap.get((Object)ExecutionLevel.CONFIGURE));
        HashSet<ElementHandler> handlers = new HashSet<ElementHandler>();
        handlers.addAll(this.elements.get((Object)ExecutionLevel.CONFIGURE).values());
        this.initLevel(handlers, ExecutionLevel.BUILD, elementMap.get((Object)ExecutionLevel.BUILD));
        this.initLevel(handlers, ExecutionLevel.RUN, elementMap.get((Object)ExecutionLevel.RUN));
    }

    Map<ExecutionLevel, List<ExecutionEntry>> elements() {
        EnumMap<ExecutionLevel, List<ExecutionEntry>> map = new EnumMap<ExecutionLevel, List<ExecutionEntry>>(ExecutionLevel.class);
        map.put(ExecutionLevel.CONFIGURE, this.elements.get((Object)ExecutionLevel.CONFIGURE).entrySet().stream().map(e -> new ExecutionEntry((ExecutionElement)e.getKey(), (ElementHandler)e.getValue())).collect(Collectors.toList()));
        map.put(ExecutionLevel.BUILD, this.elements.get((Object)ExecutionLevel.BUILD).entrySet().stream().map(e -> new ExecutionEntry((ExecutionElement)e.getKey(), (ElementHandler)e.getValue())).collect(Collectors.toList()));
        map.put(ExecutionLevel.RUN, this.elements.get((Object)ExecutionLevel.RUN).entrySet().stream().map(e -> new ExecutionEntry((ExecutionElement)e.getKey(), (ElementHandler)e.getValue())).collect(Collectors.toList()));
        return map;
    }

    private void initConfigure(List<ExecutionElement> elementList) {
        Map<ExecutionElement, ElementHandler> map = this.elements.get((Object)ExecutionLevel.CONFIGURE);
        map.clear();
        elementList.stream().filter(ExecutionElement.Line.class::isInstance).map(ExecutionElement.Line.class::cast).filter(e -> this.hubHandler.isSupportedCommand(e.tokens().get(0).getText())).findFirst().ifPresentOrElse(e -> {
            this.hubHandler.configure((ExecutionElement.Line)e);
            map.put((ExecutionElement)e, this.hubHandler);
        }, () -> map.put(this.hubHandler.defaultElement(), this.hubHandler));
        elementList.stream().filter(ExecutionElement.Line.class::isInstance).map(ExecutionElement.Line.class::cast).filter(e -> this.compilerHandler.isSupportedCommand(e.tokens().get(0).getText())).findFirst().ifPresentOrElse(e -> {
            this.compilerHandler.configure((ExecutionElement.Line)e);
            map.put((ExecutionElement)e, this.compilerHandler);
        }, () -> map.put(this.compilerHandler.defaultElement(), this.compilerHandler));
        elementList.stream().filter(ExecutionElement.Line.class::isInstance).map(ExecutionElement.Line.class::cast).filter(e -> this.librariesHandler.isSupportedCommand(e.tokens().get(0).getText())).findFirst().ifPresentOrElse(e -> {
            this.librariesHandler.configure((ExecutionElement.Line)e);
            map.put((ExecutionElement)e, this.librariesHandler);
        }, () -> map.put(this.librariesHandler.defaultElement(), this.librariesHandler));
    }

    private void initLevel(Set<ElementHandler> handlers, ExecutionLevel level, List<ExecutionElement> elementList) {
        Map<ExecutionElement, ElementHandler> map = this.elements.get((Object)level);
        map.clear();
        for (ExecutionElement element : elementList) {
            try {
                ElementHandler handler = this.findHandler(level, element);
                if (!handlers.add(handler)) {
                    throw new IllegalStateException("Duplicate handler");
                }
                map.put(element, handler);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private ElementHandler findHandler(ExecutionLevel level, ExecutionElement element) throws IllegalArgumentException {
        if (element instanceof ExecutionElement.File) {
            ExecutionElement.File fileElement = (ExecutionElement.File)element;
            this.checkFile(fileElement.file());
            return this.fileHandlerProviders.stream().flatMap(p -> p.createHandler(this.project, level, fileElement).stream()).findFirst().orElseGet(() -> new DefaultFileHandler(this.project, level, fileElement));
        }
        if (element instanceof ExecutionElement.Line) {
            ExecutionElement.Line lineElement = (ExecutionElement.Line)element;
            return this.lineHandlerProviders.stream().flatMap(p -> p.createHandler(this.project, level, lineElement).stream()).findFirst().orElseGet(() -> new DefaultLineHandler(this.project, level, lineElement));
        }
        throw new IllegalArgumentException();
    }

    private Optional<LineHandler> findInternalHandler(PraxisProject project, ExecutionLevel level, ExecutionElement.Line lineElement) {
        List<Token> tokens = lineElement.tokens();
        String command = tokens.get(0).getText();
        if (this.compilerHandler.isSupportedCommand(command)) {
            return Optional.of(this.compilerHandler);
        }
        if (this.librariesHandler.isSupportedCommand(command)) {
            return Optional.of(this.librariesHandler);
        }
        return Optional.empty();
    }

    public void setLibraries(List<URI> libs) {
        ArrayList<URI> working = new ArrayList<URI>(libs);
        boolean active = this.project.isActive();
        if (!active) {
            this.libraries.clear();
        }
        working.removeAll(this.libraries);
        if (working.isEmpty()) {
            return;
        }
        this.libraries.addAll(working);
        if (active) {
            try {
                ProjectHelper helper = (ProjectHelper)((Object)this.project.getLookup().lookup(ProjectHelper.class));
                if (helper != null) {
                    for (URI lib : working) {
                        String script = "cd " + String.valueOf(this.project.getProjectDirectory().toURI()) + "\n" + this.librariesHandler.librariesScript(List.of(lib));
                        helper.execScript(script, Callback.create(r -> {
                            if (r.isError()) {
                                this.libraries.remove(lib);
                                Object msg = Bundle.ERR_addLibraryError(lib);
                                if (!r.args().isEmpty()) {
                                    msg = (String)msg + "\n" + String.valueOf(r.args().get(0));
                                }
                                ProjectDialogManager.get(this.project).reportError((String)msg);
                            }
                        }));
                    }
                }
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        this.pcs.firePropertyChange("libraries", null, null);
    }

    void updateLibraries(PArray libs) {
        List<URI> newLibs = libs.stream().flatMap(v -> PResource.from((Value)v).stream()).map(PResource::value).toList();
        if (this.libraries.equals(newLibs)) {
            return;
        }
        this.libraries.clear();
        this.libraries.addAll(newLibs);
        this.pcs.firePropertyChange("libraries", null, null);
    }

    @Override
    public List<URI> getLibraries() {
        return List.copyOf(this.libraries);
    }

    @Override
    public void setJavaRelease(int release) throws Exception {
        if (this.javaRelease == release) {
            return;
        }
        if (this.project.isActive()) {
            throw new IllegalStateException("Cannot change source version for active project");
        }
        if (release < 21 || release > DefaultPraxisProject.MAX_JAVA_VERSION) {
            throw new IllegalArgumentException();
        }
        this.javaRelease = release;
        this.pcs.firePropertyChange("java-release", null, null);
    }

    @Override
    public int getJavaRelease() {
        return this.javaRelease;
    }

    public void setHubConfiguration(String config) throws Exception {
        if (this.hubHandler.hubConfiguration.equals(config)) {
            return;
        }
        if (this.project.isActive()) {
            throw new IllegalStateException("Cannot change hub for active project");
        }
        this.hubHandler.configure(config);
    }

    public String getHubConfiguration() {
        return this.hubHandler.hubConfiguration;
    }

    private void checkFile(FileObject file) {
        if (!FileUtil.isParentOf((FileObject)this.project.getProjectDirectory(), (FileObject)file)) {
            throw new IllegalArgumentException("All files must be contained in project");
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    static {
        String config;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(ProjectPropertiesImpl.class.getResourceAsStream("/org/praxislive/ide/project/resources/default-hub.txt"), Charset.forName("UTF-8")));){
            config = reader.lines().collect(Collectors.joining("\n"));
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            config = "";
        }
        DEFAULT_HUB_CONFIG = config;
    }

    private class HubLineHandler
    implements LineHandler {
        private final String DEFAULT_HUB = "hub {\n" + DEFAULT_HUB_CONFIG + "\n}";
        private final Set<String> commands = Set.of("hub-configure", "hub");
        private String hubConfiguration = DEFAULT_HUB_CONFIG;

        private HubLineHandler() {
        }

        @Override
        public void process(Callback callback) throws Exception {
            ((ProjectHelper)((Object)ProjectPropertiesImpl.this.project.getLookup().lookup(ProjectHelper.class))).execScript("hub {\n" + this.hubConfiguration + "\n}", callback);
        }

        @Override
        public String rewrite(String line) {
            return "hub {\n" + this.hubConfiguration + "\n}";
        }

        private boolean isSupportedCommand(String command) {
            return this.commands.contains(command);
        }

        private void configure(ExecutionElement.Line element) {
            try {
                String config = element.tokens().get(1).getText();
                this.configure(config);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        private void configure(String config) throws Exception {
            config = config.lines().filter(Predicate.not(String::isBlank)).collect(Collectors.joining("\n"));
            HubConfiguration checkConfig = HubConfiguration.fromMap((PMap)PMap.parse((String)config));
            this.hubConfiguration = config;
        }

        private ExecutionElement.Line defaultElement() {
            return ExecutionElement.forLine(this.DEFAULT_HUB);
        }
    }

    private class CompilerLineHandler
    implements LineHandler {
        private final Set<String> commands = Set.of("java-compiler-release", "compiler");

        private CompilerLineHandler() {
        }

        @Override
        public void process(Callback callback) throws Exception {
            String script = this.compilerScript(ProjectPropertiesImpl.this.getJavaRelease());
            ((ProjectHelper)((Object)ProjectPropertiesImpl.this.project.getLookup().lookup(ProjectHelper.class))).execScript(script, callback);
        }

        @Override
        public String rewrite(String line) {
            return this.compilerScript(ProjectPropertiesImpl.this.getJavaRelease());
        }

        private boolean isSupportedCommand(String command) {
            return this.commands.contains(command);
        }

        private void configure(ExecutionElement.Line element) {
            try {
                int release;
                if ("java-compiler-release".equals(element.tokens().get(0).getText())) {
                    release = Integer.parseInt(element.tokens().get(1).getText());
                } else {
                    PMap params = PMap.parse((String)element.tokens().get(1).getText());
                    release = params.getInt("release", 21);
                }
                if (release < 21) {
                    release = 21;
                }
                ProjectPropertiesImpl.this.javaRelease = release;
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        private String compilerScript(int release) {
            return "compiler {\n  release " + release + "\n}";
        }

        private ExecutionElement.Line defaultElement() {
            return ExecutionElement.forLine(this.compilerScript(21));
        }
    }

    private class LibrariesLineHandler
    implements LineHandler {
        private final Set<String> commands = Set.of("add-libs", "libraries");

        private LibrariesLineHandler() {
        }

        @Override
        public void process(Callback callback) throws Exception {
            String script = "cd " + String.valueOf(ProjectPropertiesImpl.this.project.getProjectDirectory().toURI()) + "\n" + this.librariesScript(ProjectPropertiesImpl.this.libraries);
            ((ProjectHelper)((Object)ProjectPropertiesImpl.this.project.getLookup().lookup(ProjectHelper.class))).execScript(script, callback);
        }

        @Override
        public String rewrite(String line) {
            return this.librariesScript(ProjectPropertiesImpl.this.libraries);
        }

        private boolean isSupportedCommand(String command) {
            return this.commands.contains(command);
        }

        private void configure(ExecutionElement.Line element) {
            ProjectPropertiesImpl.this.libraries.clear();
            try {
                Token token = element.tokens().get(1);
                if (token.getType() == Token.Type.SUBCOMMAND) {
                    ProjectPropertiesImpl.this.libraries.add(new URI("config/libs/*.jar"));
                } else {
                    PArray arr = PArray.parse((String)element.tokens().get(1).getText());
                    for (Value v : arr) {
                        URI lib = new URI(v.toString());
                        ProjectPropertiesImpl.this.libraries.add(lib);
                    }
                }
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        private ExecutionElement.Line defaultElement() {
            return ExecutionElement.forLine("libraries {}");
        }

        private String librariesScript(List<URI> libs) {
            if (libs.isEmpty()) {
                return "libraries {}";
            }
            return libs.stream().map(u -> SyntaxUtils.escape((String)u.toString())).collect(Collectors.joining("\n  ", "libraries {\n  ", "\n}"));
        }
    }

    private class FileListener
    extends FileChangeAdapter {
        private FileListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fileDeleted(FileEvent fe) {
            ProjectPropertiesImpl projectPropertiesImpl = ProjectPropertiesImpl.this;
            synchronized (projectPropertiesImpl) {
                EventQueue.invokeLater(() -> this.checkFileDeleted(fe.getFile()));
            }
        }

        private void checkFileDeleted(FileObject file) {
            boolean changed = false;
            for (Map.Entry<ExecutionLevel, Map<ExecutionElement, ElementHandler>> category : ProjectPropertiesImpl.this.elements.entrySet()) {
                changed = category.getValue().keySet().removeIf(el -> el instanceof ExecutionElement.File && ((ExecutionElement.File)el).file().equals(file));
            }
            if (changed) {
                ProjectPropertiesImpl.this.pcs.firePropertyChange("elements", null, null);
            }
        }

        public void fileRenamed(FileRenameEvent fe) {
        }
    }
}

