/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.praxislive.base.AbstractAsyncControl;
import org.praxislive.core.Call;
import org.praxislive.core.ComponentAddress;
import org.praxislive.core.ComponentInfo;
import org.praxislive.core.Control;
import org.praxislive.core.ControlAddress;
import org.praxislive.core.Info;
import org.praxislive.core.Packet;
import org.praxislive.core.PacketRouter;
import org.praxislive.core.RootHub;
import org.praxislive.core.Value;
import org.praxislive.core.protocols.ComponentProtocol;
import org.praxislive.core.services.RootFactoryService;
import org.praxislive.core.services.RootManagerService;
import org.praxislive.core.services.Service;
import org.praxislive.core.services.ServiceUnavailableException;
import org.praxislive.core.services.Services;
import org.praxislive.core.services.SystemManagerService;
import org.praxislive.core.types.PReference;
import org.praxislive.ide.core.api.AbstractIDERoot;
import org.praxislive.ide.core.api.Task;
import org.praxislive.ide.project.DefaultPraxisProject;
import org.praxislive.ide.project.api.PraxisProject;
import org.praxislive.ide.project.spi.RootLifecycleHandler;
import org.praxislive.ide.project.ui.ProjectDialogManager;

class ServicesOverride
extends AbstractIDERoot
implements RootHub.ServiceProvider {
    private static final Logger LOG = Logger.getLogger(ServicesOverride.class.getName());
    private static final ComponentInfo INFO = Info.component().merge(ComponentProtocol.API_INFO).merge(RootManagerService.API_INFO).control("new-root-instance", RootFactoryService.NEW_ROOT_INSTANCE_INFO).control("system-exit", SystemManagerService.SYSTEM_EXIT_INFO).build();
    private final DefaultPraxisProject project;
    private final Set<String> knownRoots;
    private ComponentAddress defaultRootManagerService;
    private ComponentAddress defaultRootFactoryService;

    ServicesOverride(DefaultPraxisProject project) {
        this.project = project;
        this.knownRoots = new LinkedHashSet<String>();
        this.registerControl("add-root", (Control)new AddRootControl());
        this.registerControl("remove-root", new RemoveRootControl());
        this.registerControl("roots", (Control)new RootsControl());
        this.registerControl("new-root-instance", (Control)new NewRootInstanceControl());
        this.registerControl("system-exit", new ExitControl());
    }

    public ComponentInfo getInfo() {
        return INFO;
    }

    public List<Class<? extends Service>> services() {
        return List.of(RootManagerService.class, RootFactoryService.class, SystemManagerService.class);
    }

    Set<String> getKnownUserRoots() {
        return this.knownRoots;
    }

    private ComponentAddress getDefaultRootManagerService() throws ServiceUnavailableException {
        if (this.defaultRootManagerService == null) {
            ComponentAddress[] services = this.getLookup().find(Services.class).map(s -> (ComponentAddress[])s.locateAll(RootManagerService.class).toArray(ComponentAddress[]::new)).orElseThrow(ServiceUnavailableException::new);
            this.defaultRootManagerService = services[services.length - 1];
        }
        return this.defaultRootManagerService;
    }

    private ComponentAddress getDefaultRootFactoryService() throws ServiceUnavailableException {
        if (this.defaultRootFactoryService == null) {
            ComponentAddress[] services = this.getLookup().find(Services.class).map(s -> (ComponentAddress[])s.locateAll(RootFactoryService.class).toArray(ComponentAddress[]::new)).orElseThrow(ServiceUnavailableException::new);
            this.defaultRootFactoryService = services[services.length - 1];
        }
        return this.defaultRootFactoryService;
    }

    private class AddRootControl
    extends AbstractAsyncControl {
        private AddRootControl() {
        }

        protected Call processInvoke(Call call) throws Exception {
            ControlAddress to = ControlAddress.of((ComponentAddress)ServicesOverride.this.getDefaultRootManagerService(), (String)"add-root");
            return Call.create((ControlAddress)to, (ControlAddress)call.to(), (long)call.time(), (List)call.args());
        }

        protected Call processResponse(Call call) throws Exception {
            Call active = this.getActiveCall();
            ServicesOverride.this.knownRoots.add(((Value)active.args().get(0)).toString());
            return this.getActiveCall().reply(call.args());
        }
    }

    private class RemoveRootControl
    implements Control {
        private final Map<String, List<Call>> pending = new HashMap<String, List<Call>>();
        private final Map<Integer, String> forwarded = new HashMap<Integer, String>();

        private RemoveRootControl() {
        }

        public void call(Call call, PacketRouter router) throws Exception {
            if (call.isRequest()) {
                this.processInvoke(call, router);
            } else {
                this.processResponse(call, router, call.isError());
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private void processInvoke(Call call, PacketRouter router) throws Exception {
            String rootID = ((Value)call.args().get(0)).toString();
            List<Call> calls = this.pending.get(rootID);
            if (calls != null) {
                LOG.log(Level.FINE, "Pending call found for root removal /{0}", rootID);
                calls.add(call);
                return;
            }
            LOG.log(Level.FINE, "No pending calls found for root removal /{0}", rootID);
            String description = "Deleting /" + rootID;
            Set<String> rootSet = Set.of(rootID);
            List tasks = ServicesOverride.this.project.getLookup().lookupAll(RootLifecycleHandler.class).stream().flatMap(handler -> handler.getDeletionTask(description, rootSet).stream()).collect(Collectors.toList());
            if (tasks.isEmpty()) {
                LOG.log(Level.FINE, "No tasks found for root removal /{0}", rootID);
                boolean remove = ProjectDialogManager.get(ServicesOverride.this.project).confirm("Remove root?", "Remove root " + ((Value)call.args().get(0)).toString());
                if (!remove) {
                    router.route((Packet)call.error(List.of()));
                    return;
                }
                this.forwardCall(rootID, call, router);
            } else {
                if (tasks.size() > 1) {
                    LOG.log(Level.WARNING, "More than one deletion task for root /{0}\nOnly first task will be run", rootID);
                }
                LOG.log(Level.FINE, "Starting root deletion task");
                Task task = (Task)tasks.get(0);
                task.execute();
                if (task.getState() == Task.State.RUNNING) {
                    LOG.log(Level.FINE, "Task still running - add PCL");
                    task.addPropertyChangeListener((PropertyChangeListener)new TaskListener(task, rootID));
                } else {
                    if (task.getState() != Task.State.COMPLETED) {
                        LOG.log(Level.FINE, "Synchronous task error");
                        router.route((Packet)call.error(List.of()));
                        return;
                    }
                    LOG.log(Level.FINE, "Task completed synchronously - forwarding call");
                    this.forwardCall(rootID, call, router);
                }
            }
            calls = new ArrayList<Call>(1);
            calls.add(call);
            this.pending.put(rootID, calls);
        }

        private void forwardCallFromTask(String rootID) throws Exception {
            LOG.log(Level.FINE, "Task Completed OK - forwarding call to remove /{0}", rootID);
            List<Call> inbound = this.pending.get(rootID);
            PacketRouter router = ServicesOverride.this.getRouter();
            this.forwardCall(rootID, inbound.get(0), router);
        }

        private void forwardCall(String rootID, Call call, PacketRouter router) throws Exception {
            ControlAddress to = ControlAddress.of((ComponentAddress)ServicesOverride.this.getDefaultRootManagerService(), (String)"remove-root");
            Call forward = Call.create((ControlAddress)to, (ControlAddress)call.to(), (long)call.time(), (List)call.args());
            this.forwarded.put(forward.matchID(), rootID);
            router.route((Packet)forward);
        }

        private void processResponse(Call call, PacketRouter router, boolean error) {
            String rootID = this.forwarded.remove(call.matchID());
            List<Call> inbound = this.pending.remove(rootID);
            for (Call in : inbound) {
                Call response = error ? in.error(call.args()) : in.reply(call.args());
                router.route((Packet)response);
            }
        }

        private void taskError(String rootID) {
            List<Call> inbound = this.pending.remove(rootID);
            PacketRouter router = ServicesOverride.this.getRouter();
            for (Call in : inbound) {
                router.route((Packet)in.error(List.of()));
            }
        }

        private class TaskListener
        implements PropertyChangeListener {
            private String rootID;
            private Task task;

            private TaskListener(Task task, String rootID) {
                this.task = task;
                this.rootID = rootID;
            }

            @Override
            public void propertyChange(PropertyChangeEvent pce) {
                if (this.task.getState() == Task.State.COMPLETED) {
                    try {
                        RemoveRootControl.this.forwardCallFromTask(this.rootID);
                        return;
                    }
                    catch (Exception ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                RemoveRootControl.this.taskError(this.rootID);
            }
        }
    }

    private class RootsControl
    extends AbstractAsyncControl {
        private RootsControl() {
        }

        protected Call processInvoke(Call call) throws Exception {
            ControlAddress to = ControlAddress.of((ComponentAddress)ServicesOverride.this.getDefaultRootManagerService(), (String)"roots");
            return Call.create((ControlAddress)to, (ControlAddress)call.to(), (long)call.time(), (List)call.args());
        }

        protected Call processResponse(Call call) throws Exception {
            return this.getActiveCall().reply(call.args());
        }
    }

    private class NewRootInstanceControl
    extends AbstractAsyncControl {
        private NewRootInstanceControl() {
        }

        protected Call processInvoke(Call call) throws Exception {
            if ("root:gui".equals(((Value)call.args().get(0)).toString())) {
                try {
                    ClassLoader loader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
                    Class<?> guiClass = Class.forName("org.praxislive.ide.pxr.gui.DockableGuiRoot", true, loader);
                    Object instance = guiClass.getDeclaredConstructor(PraxisProject.class).newInstance(ServicesOverride.this.project);
                    return call.reply((Value)PReference.of(instance));
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            ControlAddress to = ControlAddress.of((ComponentAddress)ServicesOverride.this.getDefaultRootFactoryService(), (String)"new-root-instance");
            return Call.create((ControlAddress)to, (ControlAddress)call.to(), (long)call.time(), (List)call.args());
        }

        protected Call processResponse(Call call) throws Exception {
            return this.getActiveCall().reply(call.args());
        }
    }

    private class ExitControl
    implements Control {
        private ExitControl() {
        }

        public void call(Call call, PacketRouter router) throws Exception {
            if (call.isRequest()) {
                for (String id : ServicesOverride.this.knownRoots) {
                    ControlAddress to = ControlAddress.of((String)("/" + id + ".stop"));
                    Call msg = Call.createQuiet((ControlAddress)to, (ControlAddress)call.from(), (long)ServicesOverride.this.getExecutionContext().getTime());
                    router.route((Packet)msg);
                }
            }
        }
    }
}

