/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.project.api;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.openide.filesystems.FileObject;
import org.praxislive.core.syntax.Token;
import org.praxislive.core.syntax.Tokenizer;

public abstract class ExecutionElement {
    private ExecutionElement() {
    }

    public static Line forLine(String script) {
        ArrayList<Token> tokens = new ArrayList<Token>();
        Iterator itr = new Tokenizer((CharSequence)script).iterator();
        while (itr.hasNext()) {
            Token t = (Token)itr.next();
            if (t.getType() == Token.Type.EOL) {
                if (!itr.hasNext()) break;
                throw new IllegalArgumentException("Script contains more than one line");
            }
            tokens.add(t);
        }
        if (tokens.isEmpty()) {
            throw new IllegalArgumentException("Empty line");
        }
        if (((Token)tokens.get(0)).getType() != Token.Type.PLAIN) {
            throw new IllegalArgumentException("First token isn't plain");
        }
        return new Line(script, List.copyOf(tokens));
    }

    public static ExecutionElement forFile(FileObject file) {
        return new File(file);
    }

    public static final class Line
    extends ExecutionElement {
        private final String line;
        private final List<Token> tokens;

        private Line(String line, List<Token> tokens) {
            this.line = line;
            this.tokens = tokens;
        }

        public String line() {
            return this.line;
        }

        public List<Token> tokens() {
            return this.tokens;
        }
    }

    public static final class File
    extends ExecutionElement {
        private final FileObject file;

        private File(FileObject file) {
            this.file = file;
        }

        public int hashCode() {
            int hash = 5;
            hash = 17 * hash + Objects.hashCode(this.file);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            File other = (File)obj;
            return Objects.equals(this.file, other.file);
        }

        public FileObject file() {
            return this.file;
        }
    }
}

