/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.project.api;

import java.beans.PropertyChangeListener;
import java.net.URI;
import java.util.List;
import org.openide.filesystems.FileObject;
import org.praxislive.ide.project.api.ExecutionElement;
import org.praxislive.ide.project.api.ExecutionLevel;
import org.praxislive.ide.project.api.PraxisProject;

public interface ProjectProperties {
    public static final String PROP_ELEMENTS = "elements";
    public static final String PROP_LIBRARIES = "libraries";
    public static final String PROP_JAVA_RELEASE = "java-release";

    public void setElements(ExecutionLevel var1, List<ExecutionElement> var2) throws Exception;

    public List<ExecutionElement> getElements(ExecutionLevel var1);

    public PraxisProject getProject();

    public void addPropertyChangeListener(PropertyChangeListener var1);

    public void removePropertyChangeListener(PropertyChangeListener var1);

    default public void addFile(ExecutionLevel level, FileObject file) throws Exception {
        List<ExecutionElement> list = this.getElements(level);
        list.add(ExecutionElement.forFile(file));
        this.setElements(level, list);
    }

    default public boolean removeFile(ExecutionLevel level, FileObject file) throws Exception {
        List<ExecutionElement> list = this.getElements(level);
        if (list.removeIf(e -> e instanceof ExecutionElement.File && ((ExecutionElement.File)e).file().equals(file))) {
            this.setElements(level, list);
            return true;
        }
        return false;
    }

    default public void addLine(ExecutionLevel level, String line) throws Exception {
        List<ExecutionElement> list = this.getElements(level);
        list.add(ExecutionElement.forLine(line));
        this.setElements(level, list);
    }

    default public boolean removeLine(ExecutionLevel level, String line) throws Exception {
        List<ExecutionElement> list = this.getElements(level);
        if (list.removeIf(e -> e instanceof ExecutionElement.Line && ((ExecutionElement.Line)e).line().equals(line))) {
            this.setElements(level, list);
            return true;
        }
        return false;
    }

    default public List<URI> getLibraries() {
        return List.of();
    }

    default public void setJavaRelease(int release) throws Exception {
        throw new UnsupportedOperationException();
    }

    default public int getJavaRelease() {
        return 21;
    }
}

