/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.project.ui;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.ListView;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.praxislive.ide.project.DefaultPraxisProject;
import org.praxislive.ide.project.api.ExecutionElement;
import org.praxislive.ide.project.api.ExecutionLevel;
import org.praxislive.ide.project.api.ProjectProperties;
import org.praxislive.ide.project.ui.Bundle;
import org.praxislive.ide.project.ui.ProjectDialogManager;

class ElementsCustomizer
extends JPanel
implements ExplorerManager.Provider {
    private ExplorerManager manager;
    private DefaultPraxisProject project;
    private ExecutionLevel level;
    private ProjectProperties props;
    private List<ExecutionElement> elements;
    private Elements children;
    private Node root;
    private JButton addFileButton;
    private JButton addLineButton;
    private JScrollPane fileList;
    private JButton removeButton;

    ElementsCustomizer(DefaultPraxisProject project, ExecutionLevel level) {
        if (project == null || level == null) {
            throw new NullPointerException();
        }
        this.project = project;
        this.level = level;
        this.props = (ProjectProperties)project.getLookup().lookup(ProjectProperties.class);
        this.manager = new ExplorerManager();
        this.elements = new ArrayList<ExecutionElement>();
        this.children = new Elements();
        this.root = new AbstractNode((Children)this.children);
        this.refreshList();
        this.manager.setRootContext(this.root);
        this.manager.addPropertyChangeListener((PropertyChangeListener)new ManagerListener());
        this.initComponents();
        ((ListView)this.fileList).setSelectionMode(0);
    }

    final void refreshList() {
        this.elements.clear();
        if (this.props != null) {
            this.elements.addAll(this.props.getElements(this.level));
        }
        this.refreshView();
    }

    private void refreshView() {
        this.children.setElements(this.elements);
    }

    List<ExecutionElement> getElements() {
        return List.copyOf(this.elements);
    }

    private void initComponents() {
        this.fileList = new ListView();
        this.addFileButton = new JButton();
        this.removeButton = new JButton();
        this.addLineButton = new JButton();
        this.addFileButton.setText(NbBundle.getMessage(ElementsCustomizer.class, (String)"ElementsCustomizer.addFileButton.text"));
        this.addFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ElementsCustomizer.this.addFileButtonActionPerformed(evt);
            }
        });
        this.removeButton.setText(NbBundle.getMessage(ElementsCustomizer.class, (String)"ElementsCustomizer.removeButton.text"));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ElementsCustomizer.this.removeButtonActionPerformed(evt);
            }
        });
        this.addLineButton.setText(NbBundle.getMessage(ElementsCustomizer.class, (String)"ElementsCustomizer.addLineButton.text"));
        this.addLineButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ElementsCustomizer.this.addLineButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.fileList, -2, 312, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.addFileButton, -1, -1, Short.MAX_VALUE).addComponent(this.removeButton, -1, -1, Short.MAX_VALUE).addComponent(this.addLineButton, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fileList, -1, 300, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.addFileButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addLineButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeButton).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void addFileButtonActionPerformed(ActionEvent evt) {
        FileObject file;
        FileChooserBuilder fcb = new FileChooserBuilder(ElementsCustomizer.class);
        fcb.setFilesOnly(true);
        fcb.setTitle(Bundle.LBL_addFile());
        fcb.setApproveText(Bundle.LBL_add());
        fcb.setDefaultWorkingDirectory(FileUtil.toFile((FileObject)this.project.getProjectDirectory()));
        fcb.forceUseOfDefaultWorkingDirectory(true);
        File add = fcb.showOpenDialog();
        if (add != null && this.validateFile(file = FileUtil.toFileObject((File)add))) {
            this.elements.add(ExecutionElement.forFile(file));
            this.refreshView();
        }
    }

    private boolean validateFile(FileObject file) {
        return FileUtil.isParentOf((FileObject)this.project.getProjectDirectory(), (FileObject)file);
    }

    private boolean isConfigFile(FileObject file) {
        FileObject configDir = this.project.getProjectDirectory().getFileObject("config");
        if (configDir == null) {
            return false;
        }
        return FileUtil.isParentOf((FileObject)configDir, (FileObject)file);
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        Node[] nodes;
        for (Node node : nodes = this.manager.getSelectedNodes()) {
            ExecutionElement element = ((ElementNode)node).getElement();
            this.elements.remove(element);
        }
        this.refreshView();
    }

    private void addLineButtonActionPerformed(ActionEvent evt) {
        NotifyDescriptor.InputLine lineInput = new NotifyDescriptor.InputLine(Bundle.LBL_addLine(), Bundle.LBL_enterInputLine());
        Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)lineInput);
        if (ret == NotifyDescriptor.OK_OPTION) {
            try {
                ExecutionElement.Line line = ExecutionElement.forLine(lineInput.getInputText());
                this.elements.add(line);
                this.refreshView();
            }
            catch (Exception ex) {
                ProjectDialogManager.get(this.project).reportError(Bundle.ERR_invalidLine());
            }
        }
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    private class Elements
    extends Children.Keys<ExecutionElement> {
        private Elements() {
        }

        void setElements(List<ExecutionElement> keys) {
            this.setKeys(keys);
        }

        protected Node[] createNodes(ExecutionElement element) {
            if (element instanceof ExecutionElement.File) {
                ExecutionElement.File fileElement = (ExecutionElement.File)element;
                FileNode node = ElementsCustomizer.this.isConfigFile(fileElement.file()) ? new FileNode(fileElement, true) : new FileNode(fileElement, false);
                return new Node[]{node};
            }
            if (element instanceof ExecutionElement.Line) {
                return new Node[]{new LineNode(ElementsCustomizer.this, (ExecutionElement.Line)element)};
            }
            return new Node[0];
        }
    }

    private class ManagerListener
    implements PropertyChangeListener {
        private ManagerListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("selectedNodes".equals(evt.getPropertyName())) {
                if (ElementsCustomizer.this.manager.getSelectedNodes().length > 0) {
                    ElementsCustomizer.this.removeButton.setEnabled(true);
                } else {
                    ElementsCustomizer.this.removeButton.setEnabled(false);
                }
            }
        }
    }

    private class ElementNode
    extends AbstractNode {
        private final ExecutionElement element;

        private ElementNode(ElementsCustomizer elementsCustomizer, ExecutionElement element) {
            super(Children.LEAF);
            this.element = element;
        }

        ExecutionElement getElement() {
            return this.element;
        }
    }

    private class LineNode
    extends ElementNode {
        private final String line;

        public LineNode(ElementsCustomizer elementsCustomizer, ExecutionElement.Line element) {
            super(elementsCustomizer, element);
            this.line = element.line();
        }

        public String getDisplayName() {
            return this.line;
        }
    }

    private class FileNode
    extends ElementNode {
        private final FileObject file;
        private final boolean config;

        private FileNode(ExecutionElement.File element, boolean config) {
            super(ElementsCustomizer.this, element);
            this.file = element.file();
            this.config = config;
        }

        public Action[] getActions(boolean context) {
            return new Action[0];
        }

        public Image getIcon(int type) {
            try {
                return DataObject.find((FileObject)this.file).getNodeDelegate().getIcon(type);
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return super.getIcon(type);
            }
        }

        public String getName() {
            return this.file.getPath();
        }

        public String getDisplayName() {
            return FileUtil.getRelativePath((FileObject)ElementsCustomizer.this.project.getProjectDirectory(), (FileObject)this.file);
        }

        public String getHtmlDisplayName() {
            if (this.config) {
                return "<i>" + this.getDisplayName() + "</i>";
            }
            return null;
        }
    }
}

