/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.project.ui;

import java.util.Objects;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.util.Exceptions;
import org.praxislive.ide.project.DefaultPraxisProject;
import org.praxislive.ide.project.ProjectPropertiesImpl;

final class HubCustomizer
extends JPanel {
    private final DefaultPraxisProject project;
    private final ProjectPropertiesImpl props;
    private boolean changed;
    private JTextArea hubTextArea;
    private JScrollPane scrollPane;

    HubCustomizer(DefaultPraxisProject project) {
        this.project = Objects.requireNonNull(project);
        this.props = (ProjectPropertiesImpl)project.getLookup().lookup(ProjectPropertiesImpl.class);
        this.initComponents();
        this.refresh();
        this.hubTextArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                HubCustomizer.this.changed = true;
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                HubCustomizer.this.changed = true;
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                HubCustomizer.this.changed = true;
            }
        });
    }

    void refresh() {
        this.hubTextArea.setText(this.props.getHubConfiguration());
        this.hubTextArea.setEnabled(!this.project.isActive());
        this.changed = false;
    }

    void updateProject() {
        if (this.changed && !this.project.isActive()) {
            try {
                this.props.setHubConfiguration(this.hubTextArea.getText());
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.hubTextArea = new JTextArea();
        this.hubTextArea.setColumns(20);
        this.hubTextArea.setRows(5);
        this.scrollPane.setViewportView(this.hubTextArea);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.scrollPane, -1, 377, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.scrollPane, -1, 285, Short.MAX_VALUE).addContainerGap()));
    }
}

