/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.project.ui;

import java.awt.Container;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.ListView;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.praxislive.core.protocols.StartableProtocol;
import org.praxislive.core.types.PBoolean;
import org.praxislive.ide.model.HubProxy;
import org.praxislive.ide.model.RootProxy;
import org.praxislive.ide.project.ui.Bundle;
import org.praxislive.ide.properties.PraxisProperty;

public final class HubUITopComponent
extends TopComponent
implements ExplorerManager.Provider {
    private static final String SYSTEM_PREFIX = "_";
    private static final String PREFERRED_ID = "HubUITopComponent";
    private static final String RESOURCE_DIR = "org/praxislive/ide/project/resources/";
    private static final String ICON_PATH = "org/praxislive/ide/project/resources/hub-action.png";
    private static HubUITopComponent instance;
    private final ExplorerManager manager = new ExplorerManager();
    private final TCListener registryListener;
    private HubNode hubNode;
    private JToolBar jToolBar1;
    private JScrollPane rootList;
    private JToggleButton systemRootToggle;

    public HubUITopComponent() {
        this.initComponents();
        ((ListView)this.rootList).setSelectionMode(0);
        this.setName(NbBundle.getMessage(HubUITopComponent.class, (String)"CTL_HubUITopComponent"));
        this.setToolTipText(NbBundle.getMessage(HubUITopComponent.class, (String)"HINT_HubUITopComponent"));
        this.setIcon(ImageUtilities.loadImage((String)ICON_PATH, (boolean)true));
        this.registryListener = new TCListener();
    }

    private void initComponents() {
        this.rootList = new ListView();
        this.jToolBar1 = new JToolBar();
        this.systemRootToggle = new JToggleButton();
        this.jToolBar1.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.systemRootToggle.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/org/praxislive/ide/project/resources/system24.png")));
        this.systemRootToggle.setToolTipText(NbBundle.getMessage(HubUITopComponent.class, (String)"LBL_ShowSystemRoots"));
        this.systemRootToggle.setActionCommand("showSystemRoots");
        this.systemRootToggle.setFocusable(false);
        this.systemRootToggle.setHorizontalTextPosition(0);
        this.systemRootToggle.setVerticalTextPosition(3);
        this.systemRootToggle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HubUITopComponent.this.systemRootToggleActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.systemRootToggle);
        this.systemRootToggle.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HubUITopComponent.class, (String)"LBL_ShowSystemRoots"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jToolBar1, -2, -1, -2).addContainerGap()).addComponent(this.rootList, -1, 200, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.rootList, -1, 200, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jToolBar1, -2, -1, -2)));
    }

    private void systemRootToggleActionPerformed(ActionEvent evt) {
        if (this.hubNode != null) {
            this.hubNode.roots.showSystem(this.systemRootToggle.isSelected());
        }
    }

    public static synchronized HubUITopComponent getDefault() {
        if (instance == null) {
            instance = new HubUITopComponent();
        }
        return instance;
    }

    public static synchronized HubUITopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Logger.getLogger(HubUITopComponent.class.getName()).warning("Cannot find HubUITopComponent component. It will not be located properly in the window system.");
            return HubUITopComponent.getDefault();
        }
        if (win instanceof HubUITopComponent) {
            return (HubUITopComponent)win;
        }
        Logger.getLogger(HubUITopComponent.class.getName()).warning("There seem to be multiple components with the 'HubUITopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return HubUITopComponent.getDefault();
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentOpened() {
        TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)this.registryListener);
        this.refresh();
    }

    public void componentClosed() {
        TopComponent.getRegistry().removePropertyChangeListener((PropertyChangeListener)this.registryListener);
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    Object readProperties(Properties p) {
        if (instance == null) {
            instance = this;
        }
        instance.readPropertiesImpl(p);
        return instance;
    }

    private void readPropertiesImpl(Properties p) {
        String version = p.getProperty("version");
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    private void refresh() {
        HubProxy hub;
        TopComponent tc;
        Node[] nodes;
        Project project = null;
        boolean foundMany = false;
        for (Node node : nodes = TopComponent.getRegistry().getActivatedNodes()) {
            Lookup lkp = node.getLookup();
            Project found = this.findProject(lkp);
            if (found == null) continue;
            if (project != null && project != found) {
                project = null;
                foundMany = true;
                break;
            }
            project = found;
        }
        if (project == null && !foundMany && (tc = TopComponent.getRegistry().getActivated()) != null) {
            project = this.findProject(tc.getLookup());
        }
        if ((hub = project != null ? (HubProxy)project.getLookup().lookup(HubProxy.class) : null) != null) {
            if (this.hubNode != null) {
                if (this.hubNode.hub == hub) {
                    return;
                }
                this.hubNode.dispose();
            }
            this.hubNode = new HubNode(hub, hub.getNodeDelegate());
            this.manager.setRootContext((Node)this.hubNode);
            this.hubNode.roots.showSystem(this.systemRootToggle.isSelected());
        } else if (foundMany) {
            if (this.hubNode == null) {
                return;
            }
            this.hubNode.dispose();
            this.hubNode = null;
            this.manager.setRootContext((Node)new AbstractNode(Children.LEAF));
        }
    }

    private Project findProject(Lookup lkp) {
        DataObject dob;
        Project project = (Project)lkp.lookup(Project.class);
        if (project == null && (dob = (DataObject)lkp.lookup(DataObject.class)) != null) {
            project = FileOwnerQuery.getOwner((FileObject)dob.getPrimaryFile());
        }
        return project;
    }

    private class TCListener
    implements PropertyChangeListener {
        private TCListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("activatedNodes".equals(evt.getPropertyName())) {
                HubUITopComponent.this.refresh();
            }
        }
    }

    private static class HubNode
    extends FilterNode {
        final HubProxy hub;
        final Roots roots;

        private HubNode(HubProxy hub, Node original) {
            this(hub, original, new Roots(original));
        }

        private HubNode(HubProxy hub, Node original, Roots roots) {
            super(original, (Children)roots);
            this.hub = hub;
            this.roots = roots;
        }

        private void dispose() {
            this.roots.dispose();
        }
    }

    private static class Roots
    extends FilterNode.Children {
        private boolean showSystem;

        Roots(Node original) {
            super(original);
        }

        protected Node[] createNodes(Node key) {
            RootProxy root = (RootProxy)key.getLookup().lookup(RootProxy.class);
            if (root == null || key.isExpert() && !this.showSystem) {
                return new Node[0];
            }
            return new Node[]{new RootNode(key, root)};
        }

        private void showSystem(boolean showSystem) {
            Node[] nodes;
            this.showSystem = showSystem;
            for (Node node : nodes = this.original.getChildren().getNodes(true)) {
                this.refreshKey(node);
            }
        }

        private void dispose() {
            this.setKeys(new Node[0]);
        }
    }

    private static class StartableAction
    extends AbstractAction {
        private final RootProxy root;
        private final boolean start;

        private StartableAction(String name, RootProxy root, boolean start) {
            super(name);
            this.root = root;
            this.start = start;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.root.send(this.start ? "start" : "stop", List.of());
        }
    }

    private static class RootNode
    extends FilterNode
    implements PropertyChangeListener {
        private static final Image ROOT_ACTIVE_ICON = ImageUtilities.loadImage((String)"org/praxislive/ide/project/resources/root_active.png", (boolean)true);
        private static final Image ROOT_IDLE_ICON = ImageUtilities.loadImage((String)"org/praxislive/ide/project/resources/root_idle.png", (boolean)true);
        private static final Image ROOT_ICON = ImageUtilities.loadImage((String)"org/praxislive/ide/project/resources/root.png", (boolean)true);
        private final RootProxy root;
        private final boolean startable;
        private final Action startAction;
        private final Action stopAction;
        boolean running;

        private RootNode(Node original, RootProxy root) {
            super(original, FilterNode.Children.LEAF);
            this.root = root;
            this.startable = root.getInfo().hasProtocol(StartableProtocol.class);
            this.startAction = new StartableAction(Bundle.LBL_startAction(), root, true);
            this.startAction.setEnabled(false);
            this.stopAction = new StartableAction(Bundle.LBL_stopAction(), root, false);
            this.stopAction.setEnabled(false);
            root.addPropertyChangeListener((PropertyChangeListener)this);
            this.disableDelegation(12);
            this.refresh();
        }

        public void destroy() throws IOException {
            super.destroy();
            this.root.removePropertyChangeListener((PropertyChangeListener)this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("is-running".equals(evt.getPropertyName())) {
                this.refresh();
            }
        }

        public Action getPreferredAction() {
            if (this.startAction.isEnabled()) {
                return this.startAction;
            }
            if (this.stopAction.isEnabled()) {
                return this.stopAction;
            }
            return null;
        }

        public Action[] getActions(boolean context) {
            if (this.startable) {
                return new Action[]{this.startAction, this.stopAction};
            }
            return new Action[0];
        }

        private void refresh() {
            String id = this.root.getAddress().rootID();
            if (this.startable) {
                this.running = Optional.ofNullable(this.root.getProperty("is-running")).map(PraxisProperty::getValue).flatMap(PBoolean::from).orElse(PBoolean.FALSE).value();
                if (this.running) {
                    this.setDisplayName(id + " " + Bundle.LBL_rootActive());
                    this.startAction.setEnabled(false);
                    this.stopAction.setEnabled(true);
                } else {
                    this.setDisplayName(id + " " + Bundle.LBL_rootIdle());
                    this.startAction.setEnabled(true);
                    this.stopAction.setEnabled(false);
                }
            } else {
                this.running = false;
                this.setDisplayName(id);
            }
            this.fireIconChange();
        }

        public Image getIcon(int type) {
            if (this.startable) {
                if (this.running) {
                    return ROOT_ACTIVE_ICON;
                }
                return ROOT_IDLE_ICON;
            }
            return ROOT_ICON;
        }
    }
}

