/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.project.ui;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Cancellable;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.praxislive.ide.project.api.PraxisProject;

public final class ImportResourcesAction
extends AbstractAction
implements ContextAwareAction {
    private static final RequestProcessor RP = new RequestProcessor(ImportResourcesAction.class);

    @Override
    public void actionPerformed(ActionEvent ev) {
        assert (false);
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new ActionImpl(actionContext);
    }

    private static class ActionImpl
    extends AbstractAction {
        private PraxisProject project;
        private FileObject folder;

        private ActionImpl(Lookup context) {
            this.project = (PraxisProject)context.lookup(PraxisProject.class);
            if (this.project != null) {
                FileObject res = this.project.getProjectDirectory().getFileObject("resources");
                FileObject d = (FileObject)context.lookup(FileObject.class);
                if (res != null && d != null && d.isFolder() && (res == d || FileUtil.isParentOf((FileObject)res, (FileObject)d))) {
                    this.folder = d;
                }
            }
            if (this.folder == null) {
                this.setEnabled(false);
                this.putValue("hideWhenDisabled", true);
            }
            this.putValue("Name", "Import...");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.folder == null) {
                return;
            }
            File[] files = new FileChooserBuilder(ImportResourcesAction.class).setTitle("Import File(s)").setFileHiding(true).setFilesOnly(true).setApproveText("OK").showMultiOpenDialog();
            if (files != null && files.length > 0) {
                RP.post((Runnable)new FileCopyTask(files, this.folder));
            }
        }
    }

    private static class FileCopyTask
    implements Runnable,
    Cancellable {
        private final File[] files;
        private final FileObject folder;
        private volatile boolean cancelled;

        private FileCopyTask(File[] files, FileObject folder) {
            this.files = files;
            this.folder = folder;
        }

        @Override
        public void run() {
            ProgressHandle ph = ProgressHandleFactory.createHandle((String)"Importing Files...", (Cancellable)this);
            ph.start(this.files.length);
            int count = 0;
            for (File file : this.files) {
                try {
                    final FileObject src = FileUtil.toFileObject((File)file);
                    ph.progress("Copying " + src.getNameExt(), count++);
                    if (src.isFolder()) {
                        ++count;
                        continue;
                    }
                    final String name = FileUtil.findFreeFileName((FileObject)this.folder, (String)src.getName(), (String)src.getExt());
                    FileUtil.runAtomicAction((FileSystem.AtomicAction)new FileSystem.AtomicAction(){

                        public void run() throws IOException {
                            FileUtil.copyFile((FileObject)src, (FileObject)folder, (String)name);
                        }
                    });
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
            ph.finish();
        }

        public boolean cancel() {
            return false;
        }
    }
}

