/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.project.ui;

import java.util.Objects;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.praxislive.ide.project.DefaultPraxisProject;
import org.praxislive.ide.project.ProjectPropertiesImpl;

final class JavaCustomizer
extends JPanel {
    private static final String JVM_TEXT = System.getProperty("java.version", "unknown") + "; " + System.getProperty("java.vm.name", "") + " " + System.getProperty("java.vm.version", "");
    private final DefaultPraxisProject project;
    private final ProjectPropertiesImpl props;
    private JLabel javaReleaseLabel;
    private JComboBox<String> javaReleaseSelect;
    private JLabel runningJVMField;
    private JLabel runningJVMLabel;
    private JLabel warningLabel;

    JavaCustomizer(DefaultPraxisProject project) {
        this.project = Objects.requireNonNull(project);
        this.props = (ProjectPropertiesImpl)project.getLookup().lookup(ProjectPropertiesImpl.class);
        this.initComponents();
        this.runningJVMField.setText(JVM_TEXT);
        for (int i = 21; i <= DefaultPraxisProject.MAX_JAVA_VERSION; ++i) {
            this.javaReleaseSelect.addItem("Java " + i);
        }
        this.refresh();
    }

    void refresh() {
        int projectRelease = this.props.getJavaRelease();
        int selectIndex = projectRelease - 21;
        String selectValue = this.javaReleaseSelect.getItemAt(selectIndex);
        if (selectValue != null) {
            this.warningLabel.setVisible(false);
            this.javaReleaseSelect.setSelectedIndex(selectIndex);
        } else {
            this.warningLabel.setVisible(true);
            this.javaReleaseSelect.setSelectedIndex(this.javaReleaseSelect.getItemCount() - 1);
        }
        this.javaReleaseSelect.setEnabled(!this.project.isActive());
    }

    void updateProject() {
        int selected = this.javaReleaseSelect.getSelectedIndex();
        if (selected < 0) {
            return;
        }
        int projectRelease = selected + 21;
        try {
            this.props.setJavaRelease(projectRelease);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void initComponents() {
        this.javaReleaseLabel = new JLabel();
        this.javaReleaseSelect = new JComboBox();
        this.runningJVMLabel = new JLabel();
        this.runningJVMField = new JLabel();
        this.warningLabel = new JLabel();
        this.javaReleaseLabel.setHorizontalAlignment(11);
        this.javaReleaseLabel.setText(NbBundle.getMessage(JavaCustomizer.class, (String)"JavaCustomizer.javaReleaseLabel.text"));
        this.runningJVMLabel.setHorizontalAlignment(11);
        this.runningJVMLabel.setText(NbBundle.getMessage(JavaCustomizer.class, (String)"JavaCustomizer.runningJVMLabel.text"));
        this.runningJVMField.setText(NbBundle.getMessage(JavaCustomizer.class, (String)"JavaCustomizer.runningJVMField.text"));
        this.warningLabel.setForeground(UIManager.getDefaults().getColor("nb.errorForeground"));
        this.warningLabel.setText(NbBundle.getMessage(JavaCustomizer.class, (String)"JavaCustomizer.warningLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.javaReleaseLabel, -2, 92, -2).addComponent(this.runningJVMLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.warningLabel, -1, -1, Short.MAX_VALUE).addGap(29, 29, 29)).addComponent(this.javaReleaseSelect, 0, -1, Short.MAX_VALUE).addComponent(this.runningJVMField, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.javaReleaseSelect, -2, -1, -2).addComponent(this.javaReleaseLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.runningJVMLabel).addComponent(this.runningJVMField)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.warningLabel).addContainerGap(208, Short.MAX_VALUE)));
    }
}

