/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.project.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.ListView;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.praxislive.ide.project.DefaultPraxisProject;
import org.praxislive.ide.project.ProjectPropertiesImpl;
import org.praxislive.ide.project.ui.Bundle;
import org.praxislive.ide.project.ui.ProjectDialogManager;

class LibrariesCustomizer
extends JPanel
implements ExplorerManager.Provider {
    private final ExplorerManager manager;
    private final DefaultPraxisProject project;
    private final ProjectPropertiesImpl props;
    private final List<URI> libraries;
    private final List<FileObject> filesToImport;
    private final LibraryChildren children;
    private final Node root;
    private JButton addButton;
    private JScrollPane fileList;
    private JButton importButton;
    private JButton removeButton;

    LibrariesCustomizer(DefaultPraxisProject project) {
        this.project = Objects.requireNonNull(project);
        this.props = (ProjectPropertiesImpl)project.getLookup().lookup(ProjectPropertiesImpl.class);
        this.libraries = new ArrayList<URI>();
        this.filesToImport = new ArrayList<FileObject>();
        this.children = new LibraryChildren();
        this.root = new AbstractNode((Children)this.children);
        this.manager = new ExplorerManager();
        this.refresh();
        this.manager.setRootContext(this.root);
        this.manager.addPropertyChangeListener((PropertyChangeListener)new ManagerListener());
        this.initComponents();
    }

    final void refresh() {
        this.libraries.clear();
        this.filesToImport.clear();
        if (this.props != null) {
            this.libraries.addAll(this.props.getLibraries());
        }
        this.refreshView();
    }

    final void updateProject() {
        this.copyFiles();
        this.props.setLibraries(this.libraries);
    }

    private void refreshView() {
        this.children.setLibraries(this.libraries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFiles() {
        if (this.filesToImport.isEmpty()) {
            return;
        }
        try {
            FileObject libFolder = FileUtil.createFolder((FileObject)this.project.getProjectDirectory(), (String)"libs");
            for (FileObject libFile : this.filesToImport) {
                FileUtil.copyFile((FileObject)libFile, (FileObject)libFolder, (String)libFile.getName());
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            this.filesToImport.clear();
        }
    }

    private void initComponents() {
        this.fileList = new ListView();
        this.importButton = new JButton();
        this.removeButton = new JButton();
        this.addButton = new JButton();
        this.importButton.setText(NbBundle.getMessage(LibrariesCustomizer.class, (String)"LibrariesCustomizer.importButton.text"));
        this.importButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LibrariesCustomizer.this.importButtonActionPerformed(evt);
            }
        });
        this.removeButton.setText(NbBundle.getMessage(LibrariesCustomizer.class, (String)"LibrariesCustomizer.removeButton.text"));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LibrariesCustomizer.this.removeButtonActionPerformed(evt);
            }
        });
        this.addButton.setText(NbBundle.getMessage(LibrariesCustomizer.class, (String)"LibrariesCustomizer.addButton.text"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LibrariesCustomizer.this.addButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.fileList, -2, 312, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.importButton, -1, 91, Short.MAX_VALUE).addComponent(this.removeButton, -1, -1, Short.MAX_VALUE).addComponent(this.addButton, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fileList, -1, 300, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.importButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeButton).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void importButtonActionPerformed(ActionEvent evt) {
        this.importFiles();
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        this.removeSelectedNodes();
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        this.addURI();
    }

    private void importFiles() {
        FileChooserBuilder fcb = new FileChooserBuilder(LibrariesCustomizer.class).setFilesOnly(true).setTitle(Bundle.TTL_import()).setApproveText(Bundle.LBL_import()).forceUseOfDefaultWorkingDirectory(true).setAcceptAllFileFilterUsed(true).setFileFilter((FileFilter)new FileNameExtensionFilter("JAR files", "jar"));
        File[] files = fcb.showMultiOpenDialog();
        if (files != null) {
            for (File file : files) {
                FileObject fo = FileUtil.toFileObject((File)file);
                if (FileUtil.isParentOf((FileObject)this.project.getProjectDirectory(), (FileObject)fo)) {
                    if (!fo.hasExt("jar")) continue;
                    this.checkAndAddURI(fo.toURI().relativize(this.project.getProjectDirectory().toURI()));
                    continue;
                }
                this.filesToImport.add(fo);
                if (!fo.hasExt("jar")) continue;
                try {
                    this.checkAndAddURI(new URI(null, null, "libs/" + file.getName(), null));
                }
                catch (URISyntaxException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            this.refreshView();
        }
    }

    private void addURI() {
        NotifyDescriptor.InputLine input = new NotifyDescriptor.InputLine(Bundle.LBL_libraryURI(), Bundle.TTL_libraryURI());
        input.createNotificationLineSupport().setInformationMessage(Bundle.HLP_libraryURI());
        Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)input);
        if (ret == NotifyDescriptor.OK_OPTION) {
            try {
                this.checkAndAddURI(new URI(input.getInputText().trim()));
            }
            catch (URISyntaxException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        this.refreshView();
    }

    private boolean checkAndAddURI(URI lib) {
        if (this.libraries.contains(lib)) {
            return false;
        }
        return this.libraries.add(lib);
    }

    private void removeSelectedNodes() {
        boolean inUse = false;
        List<URI> existing = this.props.getLibraries();
        for (Node node : this.manager.getSelectedNodes()) {
            if (!(node instanceof LibraryNode)) continue;
            URI lib = ((LibraryNode)node).uri;
            if (this.project.isActive()) {
                if (existing.contains(lib)) {
                    inUse = true;
                    continue;
                }
                this.libraries.remove(lib);
                continue;
            }
            this.libraries.remove(lib);
        }
        if (inUse) {
            ProjectDialogManager.get(this.project).reportError(Bundle.ERR_removingInUse());
        }
        this.refreshView();
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    private class LibraryChildren
    extends Children.Keys<URI> {
        private LibraryChildren() {
        }

        void setLibraries(List<URI> keys) {
            this.setKeys(keys);
        }

        protected Node[] createNodes(URI key) {
            return new Node[]{new LibraryNode(LibrariesCustomizer.this, key)};
        }
    }

    private class ManagerListener
    implements PropertyChangeListener {
        private ManagerListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("selectedNodes".equals(evt.getPropertyName())) {
                if (LibrariesCustomizer.this.manager.getSelectedNodes().length > 0) {
                    LibrariesCustomizer.this.removeButton.setEnabled(true);
                } else {
                    LibrariesCustomizer.this.removeButton.setEnabled(false);
                }
            }
        }
    }

    private class LibraryNode
    extends AbstractNode {
        private final URI uri;

        LibraryNode(LibrariesCustomizer librariesCustomizer, URI uri) {
            super(Children.LEAF);
            this.uri = uri;
        }

        public Action getPreferredAction() {
            return null;
        }

        public Action[] getActions(boolean context) {
            return new Action[0];
        }

        public String getDisplayName() {
            return this.uri.toString();
        }
    }
}

