/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.project.ui;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.spi.project.ui.CustomizerProvider;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.praxislive.ide.project.DefaultPraxisProject;
import org.praxislive.ide.project.ProjectPropertiesImpl;
import org.praxislive.ide.project.api.ExecutionLevel;
import org.praxislive.ide.project.ui.Bundle;
import org.praxislive.ide.project.ui.ElementsCustomizer;
import org.praxislive.ide.project.ui.HubCustomizer;
import org.praxislive.ide.project.ui.JavaCustomizer;
import org.praxislive.ide.project.ui.LibrariesCustomizer;

public class PraxisCustomizerProvider
implements CustomizerProvider,
ProjectCustomizer.CategoryComponentProvider {
    private final ProjectCustomizer.Category build;
    private final ProjectCustomizer.Category run;
    private final ProjectCustomizer.Category hub;
    private final ProjectCustomizer.Category libraries;
    private final ProjectCustomizer.Category java;
    private final DefaultPraxisProject project;
    private ElementsCustomizer buildFiles;
    private ElementsCustomizer runFiles;
    private HubCustomizer hubCustomizer;
    private LibrariesCustomizer librariesCustomizer;
    private JavaCustomizer javaCustomizer;

    public PraxisCustomizerProvider(DefaultPraxisProject project) {
        this.project = project;
        this.build = ProjectCustomizer.Category.create((String)"build", (String)Bundle.LBL_buildLevelElements(), null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[0]);
        this.run = ProjectCustomizer.Category.create((String)"run", (String)Bundle.LBL_runLevelElements(), null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[0]);
        this.hub = ProjectCustomizer.Category.create((String)"hub", (String)Bundle.LBL_hubConfiguration(), null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[0]);
        this.libraries = ProjectCustomizer.Category.create((String)"libraries", (String)Bundle.LBL_libraries(), null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[0]);
        this.java = ProjectCustomizer.Category.create((String)"java", (String)Bundle.LBL_compiler(), null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[0]);
    }

    public void showCustomizer() {
        ProjectCustomizer.Category[] categories = new ProjectCustomizer.Category[]{this.build, this.run, this.hub, this.libraries, this.java};
        if (this.buildFiles != null) {
            this.buildFiles.refreshList();
        }
        if (this.runFiles != null) {
            this.runFiles.refreshList();
        }
        if (this.librariesCustomizer != null) {
            this.librariesCustomizer.refresh();
        }
        if (this.javaCustomizer != null) {
            this.javaCustomizer.refresh();
        }
        if (this.hubCustomizer != null) {
            this.hubCustomizer.refresh();
        }
        Dialog dialog = ProjectCustomizer.createCustomizerDialog((ProjectCustomizer.Category[])categories, (ProjectCustomizer.CategoryComponentProvider)this, null, (ActionListener)new OKButtonListener(), null);
        dialog.setTitle(ProjectUtils.getInformation((Project)this.project).getDisplayName());
        dialog.setVisible(true);
    }

    public JComponent create(ProjectCustomizer.Category category) {
        if (this.build.equals(category)) {
            if (this.buildFiles == null) {
                this.buildFiles = new ElementsCustomizer(this.project, ExecutionLevel.BUILD);
            } else {
                this.buildFiles.refreshList();
            }
            return this.buildFiles;
        }
        if (this.run.equals(category)) {
            if (this.runFiles == null) {
                this.runFiles = new ElementsCustomizer(this.project, ExecutionLevel.RUN);
            } else {
                this.runFiles.refreshList();
            }
            return this.runFiles;
        }
        if (this.libraries.equals(category)) {
            if (this.librariesCustomizer == null) {
                this.librariesCustomizer = new LibrariesCustomizer(this.project);
            } else {
                this.librariesCustomizer.refresh();
            }
            return this.librariesCustomizer;
        }
        if (this.java.equals(category)) {
            if (this.javaCustomizer == null) {
                this.javaCustomizer = new JavaCustomizer(this.project);
            } else {
                this.javaCustomizer.refresh();
            }
            return this.javaCustomizer;
        }
        if (this.hub.equals(category)) {
            if (this.hubCustomizer == null) {
                this.hubCustomizer = new HubCustomizer(this.project);
            } else {
                this.hubCustomizer.refresh();
            }
            return this.hubCustomizer;
        }
        return new JPanel();
    }

    private class OKButtonListener
    implements ActionListener {
        private OKButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ProjectPropertiesImpl props = (ProjectPropertiesImpl)PraxisCustomizerProvider.this.project.getLookup().lookup(ProjectPropertiesImpl.class);
            if (props == null) {
                return;
            }
            if (PraxisCustomizerProvider.this.buildFiles != null) {
                props.setElements(ExecutionLevel.BUILD, PraxisCustomizerProvider.this.buildFiles.getElements());
            }
            if (PraxisCustomizerProvider.this.runFiles != null) {
                props.setElements(ExecutionLevel.RUN, PraxisCustomizerProvider.this.runFiles.getElements());
            }
            if (PraxisCustomizerProvider.this.librariesCustomizer != null) {
                PraxisCustomizerProvider.this.librariesCustomizer.updateProject();
            }
            if (PraxisCustomizerProvider.this.javaCustomizer != null) {
                PraxisCustomizerProvider.this.javaCustomizer.updateProject();
            }
            if (PraxisCustomizerProvider.this.hubCustomizer != null) {
                PraxisCustomizerProvider.this.hubCustomizer.updateProject();
            }
        }
    }
}

