/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.project.ui;

import org.netbeans.api.queries.VisibilityQuery;
import org.openide.filesystems.FileObject;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.praxislive.ide.project.api.PraxisProject;
import org.praxislive.ide.project.ui.PraxisFileNode;
import org.praxislive.ide.project.ui.PraxisFolderNode;

class PraxisFolderChildren
extends FilterNode.Children {
    private static final String CONFIG_FOLDER_NAME = "config";
    private static final String PXP_EXT = "pxp";
    private static final Node[] EMPTY_NODES = new Node[0];
    private PraxisProject project;

    public PraxisFolderChildren(PraxisProject project, Node original) {
        super(original);
        this.project = project;
    }

    protected Node[] createNodes(Node original) {
        FileObject fob = (FileObject)original.getLookup().lookup(FileObject.class);
        if (fob != null) {
            if (!VisibilityQuery.getDefault().isVisible(fob)) {
                return EMPTY_NODES;
            }
            if (fob.isFolder()) {
                if (CONFIG_FOLDER_NAME.equals(fob.getName()) && fob.getParent().equals(this.project.getProjectDirectory())) {
                    return EMPTY_NODES;
                }
                return new Node[]{new PraxisFolderNode(this.project, original)};
            }
            if (fob.hasExt(PXP_EXT)) {
                return EMPTY_NODES;
            }
            return new Node[]{new PraxisFileNode(this.project, original)};
        }
        return EMPTY_NODES;
    }
}

