/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.project.ui;

import java.awt.Image;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.ProjectSensitiveActions;
import org.openide.awt.Actions;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.praxislive.ide.project.api.PraxisProject;
import org.praxislive.ide.project.ui.Bundle;
import org.praxislive.ide.project.ui.PraxisFolderChildren;
import org.praxislive.ide.project.wizard.EmbedRuntime;

class PraxisProjectNode
extends FilterNode {
    private static final Action SYSTEM_OPEN_ACTION = Actions.forID((String)"Edit", (String)"org.netbeans.core.ui.sysopen.SystemOpenAction");
    private static final String ICON_PATH = "org/praxislive/ide/project/resources/pxp16.png";

    public PraxisProjectNode(PraxisProject project, Node original) {
        super(original, (Children)new PraxisFolderChildren(project, original), (Lookup)new ProxyLookup(new Lookup[]{original.getLookup(), Lookups.singleton((Object)project)}));
    }

    public Image getIcon(int type) {
        Image image = ImageUtilities.loadImage((String)ICON_PATH, (boolean)true);
        if (image == null) {
            return super.getIcon(type);
        }
        return image;
    }

    public Image getOpenedIcon(int type) {
        Image image = ImageUtilities.loadImage((String)ICON_PATH, (boolean)true);
        if (image == null) {
            return super.getOpenedIcon(type);
        }
        return image;
    }

    public Action[] getActions(boolean context) {
        return new Action[]{CommonProjectActions.newFileAction(), null, ProjectSensitiveActions.projectCommandAction((String)"run", (String)"Run", null), ProjectSensitiveActions.projectCommandAction((String)"build", (String)"Build", null), ProjectSensitiveActions.projectCommandAction((String)"clean", (String)"Clean", null), null, new EmbedRuntimeAction(), CommonProjectActions.setAsMainProjectAction(), SYSTEM_OPEN_ACTION, CommonProjectActions.closeProjectAction(), null, CommonProjectActions.customizeProjectAction()};
    }

    private class EmbedRuntimeAction
    extends AbstractAction {
        private EmbedRuntimeAction() {
            super(Bundle.ACT_EmbedRuntime());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PraxisProject project = (PraxisProject)PraxisProjectNode.this.getLookup().lookup(PraxisProject.class);
            if (project != null) {
                EmbedRuntime.getInstance().process(project);
            }
        }
    }
}

