/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.project.ui;

import java.util.List;
import java.util.Map;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.praxislive.core.Value;
import org.praxislive.ide.core.api.Task;
import org.praxislive.ide.project.api.ExecutionElement;
import org.praxislive.ide.project.api.ExecutionLevel;
import org.praxislive.ide.project.api.PraxisProject;
import org.praxislive.ide.project.ui.WarningsDialogPanel;

public class ProjectDialogManager {
    private static final ProjectDialogManager INSTANCE = new ProjectDialogManager();

    private ProjectDialogManager() {
    }

    public void reportError(String message) {
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
    }

    public void reportWarnings(Map<Task, List<String>> warnings) {
        WarningsDialogPanel panel = new WarningsDialogPanel(warnings);
        NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)panel, 2);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
    }

    @Deprecated
    public void showWarningsDialog(PraxisProject project, Map<Task, List<String>> warnings) {
        this.reportWarnings(warnings);
    }

    public boolean confirm(String title, String message) {
        return this.confirm(title, message, -1);
    }

    public boolean confirmOnError(String title, String message) {
        return this.confirm(title, message, 0);
    }

    private boolean confirm(String title, String message, int type) {
        NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)message, title, 0, type);
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)nd) == NotifyDescriptor.YES_OPTION;
    }

    @Deprecated
    public boolean continueOnError(PraxisProject project, ExecutionLevel level, ExecutionElement element, List<Value> args) {
        StringBuilder sb = new StringBuilder();
        if (element instanceof ExecutionElement.File) {
            FileObject file = ((ExecutionElement.File)element).file();
            String path = FileUtil.getRelativePath((FileObject)project.getProjectDirectory(), (FileObject)file);
            if (path == null) {
                path = file.getPath();
            }
            sb.append("Error executing ");
            sb.append(path);
            sb.append(".\n");
        } else if (element instanceof ExecutionElement.Line) {
            String cmd = ((ExecutionElement.Line)element).line();
            sb.append("Error executing ");
            sb.append(cmd);
            sb.append(".\n");
        }
        sb.append("Continue ");
        if (level == ExecutionLevel.BUILD) {
            sb.append("building");
        } else {
            sb.append("running");
        }
        sb.append(" project?");
        NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)sb.toString(), "Execution Error", 0, 0);
        Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
        return ret == NotifyDescriptor.YES_OPTION;
    }

    public static ProjectDialogManager getDefault() {
        return INSTANCE;
    }

    public static ProjectDialogManager get(PraxisProject project) {
        return ProjectDialogManager.getDefault();
    }
}

