/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.project.ui;

import java.awt.Cursor;
import java.awt.Dimension;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openide.awt.HtmlRenderer;
import org.praxislive.ide.core.api.Task;

class WarningsDialogPanel
extends JPanel {
    private JScrollPane jScrollPane1;
    private JLabel label;
    private JList warningsList;

    WarningsDialogPanel(Map<Task, List<String>> warnings) {
        this.initComponents();
        this.initListModel(warnings);
        this.warningsList.setCellRenderer(HtmlRenderer.createRenderer());
        this.initLabel(this.warningsList.getModel().getSize());
    }

    private void initListModel(Map<Task, List<String>> warnings) {
        DefaultListModel<Object> model = new DefaultListModel<Object>();
        for (Map.Entry<Task, List<String>> entry : warnings.entrySet()) {
            String taskDesc = entry.getKey().description().orElse(entry.getKey().getClass().getSimpleName());
            model.addElement("<html><b>" + taskDesc + "</b>");
            for (String warning : entry.getValue()) {
                model.addElement(warning);
            }
        }
        this.warningsList.setModel(model);
    }

    private void initLabel(int warningsCount) {
        StringBuilder sb = new StringBuilder();
        sb.append("Project execution completed with ");
        if (warningsCount == 1) {
            sb.append("1 warning.");
        } else {
            sb.append(warningsCount);
            sb.append(" warnings.");
        }
        this.label.setText(sb.toString());
    }

    private void initComponents() {
        this.label = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.warningsList = new JList();
        this.setPreferredSize(new Dimension(500, 350));
        this.label.setText("TEMP TEXT");
        this.warningsList.setSelectionMode(0);
        this.warningsList.setCursor(new Cursor(0));
        this.jScrollPane1.setViewportView(this.warningsList);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 396, Short.MAX_VALUE).addComponent(this.label)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.label).addGap(18, 18, 18).addComponent(this.jScrollPane1, -1, 191, Short.MAX_VALUE).addContainerGap()));
    }
}

