/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.project.wizard;

import java.awt.Component;
import java.awt.EventQueue;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.text.MessageFormat;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import org.netbeans.api.java.platform.JavaPlatform;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.praxislive.ide.core.embedder.CORE;
import org.praxislive.ide.project.api.PraxisProject;
import org.praxislive.ide.project.wizard.Bundle;
import org.praxislive.ide.project.wizard.EmbedRuntimeJDKPanel;
import org.praxislive.ide.project.wizard.EmbedRuntimeNamePanel;

public final class EmbedRuntime {
    private static final EmbedRuntime INSTANCE = new EmbedRuntime();
    private static final RequestProcessor RP = new RequestProcessor(EmbedRuntime.class);
    private static final String BIN = "bin";
    private static final String MODS = "mods";
    private static final String JDK = "jdk";

    private EmbedRuntime() {
    }

    public void process(PraxisProject project) {
        EmbedRuntimeNamePanel namePanel = new EmbedRuntimeNamePanel(project);
        EmbedRuntimeJDKPanel jdkPanel = new EmbedRuntimeJDKPanel();
        List<EmbedRuntimeJDKPanel> panels = List.of(namePanel, jdkPanel);
        String[] steps = new String[panels.size()];
        for (int i = 0; i < panels.size(); ++i) {
            Component c = ((WizardDescriptor.Panel)panels.get(i)).getComponent();
            steps[i] = c.getName();
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps);
            jc.putClientProperty("WizardPanel_autoWizardStyle", true);
            jc.putClientProperty("WizardPanel_contentDisplayed", true);
            jc.putClientProperty("WizardPanel_contentNumbered", true);
        }
        WizardDescriptor wiz = new WizardDescriptor((WizardDescriptor.Iterator)new WizardDescriptor.ArrayIterator(panels));
        wiz.setTitleFormat(new MessageFormat("{0}"));
        wiz.setTitle(Bundle.TTL_ImportRuntime());
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)wiz) == WizardDescriptor.FINISH_OPTION) {
            String launcherName = wiz.getProperty("LauncherName").toString();
            Object includeJDK = wiz.getProperty("EmbedJDK");
            this.handleImport(project, launcherName, includeJDK instanceof Boolean ? (Boolean)includeJDK : false);
        }
    }

    private void handleImport(PraxisProject project, String launcherName, boolean includeJDK) {
        RP.execute(() -> this.handleImportAsync(project.getProjectDirectory(), launcherName, includeJDK));
    }

    private void handleImportAsync(FileObject folder, String launcherName, boolean includeJDK) {
        if (folder.getFileObject(BIN) != null || folder.getFileObject(MODS) != null || folder.getFileObject(JDK) != null) {
            EventQueue.invokeLater(this::errorExists);
            return;
        }
        try {
            Path runtimePath = CORE.installDir();
            Path projectPath = FileUtil.toFile((FileObject)folder).toPath();
            Path binPath = Files.createDirectory(projectPath.resolve(BIN), new FileAttribute[0]);
            Path modsPath = Files.createDirectory(projectPath.resolve(MODS), new FileAttribute[0]);
            this.copyFiles(runtimePath.resolve(BIN), binPath);
            this.copyFiles(runtimePath.resolve(MODS), modsPath);
            this.renameLaunchers(binPath, launcherName);
            if (includeJDK) {
                List jdkFolders = JavaPlatform.getDefault().getInstallFolders().stream().collect(Collectors.toList());
                if (jdkFolders.size() != 1) {
                    throw new IllegalStateException("Java platform has unsupported number of install folders");
                }
                Path jdkSrc = FileUtil.toFile((FileObject)((FileObject)jdkFolders.get(0))).toPath();
                Path jdkDst = Files.createDirectory(projectPath.resolve(JDK), new FileAttribute[0]);
                this.copyFiles(jdkSrc, jdkDst);
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void copyFiles(final Path src, final Path dst) throws IOException {
        Files.walkFileTree(src, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                block2: {
                    Path targetDir = dst.resolve(src.relativize(dir));
                    try {
                        Files.copy(dir, targetDir, new CopyOption[0]);
                        EmbedRuntime.this.ensureWritable(targetDir);
                    }
                    catch (FileAlreadyExistsException e) {
                        if (Files.isDirectory(targetDir, new LinkOption[0])) break block2;
                        throw e;
                    }
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Path targetFile = dst.resolve(src.relativize(file));
                Files.copy(file, targetFile, StandardCopyOption.COPY_ATTRIBUTES);
                EmbedRuntime.this.ensureWritable(targetFile);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private void renameLaunchers(Path binPath, String launcherName) throws IOException {
        Files.move(binPath.resolve("praxis"), binPath.resolve(launcherName), new CopyOption[0]);
        Files.move(binPath.resolve("praxis.bat"), binPath.resolve(launcherName + ".bat"), new CopyOption[0]);
    }

    private void errorExists() {
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.ERR_RuntimeFoldersExist(), 0));
    }

    private void ensureWritable(Path path) {
        if (Files.isWritable(path)) {
            return;
        }
        try {
            PosixFileAttributeView posix = Files.getFileAttributeView(path, PosixFileAttributeView.class, new LinkOption[0]);
            if (posix != null) {
                Set<PosixFilePermission> perms = posix.readAttributes().permissions();
                perms.add(PosixFilePermission.OWNER_WRITE);
                posix.setPermissions(perms);
                return;
            }
            DosFileAttributeView dos = Files.getFileAttributeView(path, DosFileAttributeView.class, new LinkOption[0]);
            if (dos != null) {
                dos.setReadOnly(false);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public static EmbedRuntime getInstance() {
        return INSTANCE;
    }
}

