/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.project.wizard;

import java.util.regex.Pattern;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.openide.WizardDescriptor;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.praxislive.ide.project.api.PraxisProject;
import org.praxislive.ide.project.wizard.Bundle;
import org.praxislive.ide.project.wizard.EmbedRuntimeNameVisual;

class EmbedRuntimeNamePanel
implements WizardDescriptor.Panel<WizardDescriptor> {
    static final Pattern VALID_NAME = Pattern.compile("[ a-zA-Z0-9_-]+");
    static final String KEY_NAME = "LauncherName";
    private final PraxisProject project;
    private final ChangeSupport cs;
    private EmbedRuntimeNameVisual component;
    private boolean valid;
    private WizardDescriptor wizard;

    EmbedRuntimeNamePanel(PraxisProject project) {
        this.project = project;
        this.cs = new ChangeSupport((Object)this);
    }

    public EmbedRuntimeNameVisual getComponent() {
        if (this.component == null) {
            String name = ProjectUtils.getInformation((Project)this.project).getName();
            this.valid = !name.isBlank();
            this.component = new EmbedRuntimeNameVisual(this, name);
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void addChangeListener(ChangeListener l) {
        this.cs.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.cs.removeChangeListener(l);
    }

    public void readSettings(WizardDescriptor wiz) {
        this.wizard = wiz;
    }

    public void storeSettings(WizardDescriptor wiz) {
        wiz.putProperty(KEY_NAME, (Object)this.getComponent().getLauncherName());
    }

    void validate() {
        boolean nowValid = this.isValidName(this.getComponent().getLauncherName());
        if (nowValid != this.valid) {
            this.valid = nowValid;
            this.cs.fireChange();
            if (this.wizard != null) {
                this.wizard.putProperty("WizardPanel_errorMessage", (Object)(this.valid ? null : Bundle.ERR_InvalidName()));
            }
        }
    }

    private boolean isValidName(String name) {
        return !name.isBlank() && VALID_NAME.matcher(name).matches();
    }
}

