/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.project.wizard;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.util.NbBundle;
import org.praxislive.ide.project.wizard.PraxisProjectWizardIterator;
import org.praxislive.ide.project.wizard.PraxisProjectWizardPanel1;

final class PraxisProjectVisualPanel1
extends JPanel
implements DocumentListener {
    private PraxisProjectWizardPanel1 wizardPanel;
    private FileChooserBuilder fileChooser;
    private File location;
    private JButton browseButton;
    private JLabel folderLabel;
    private JTextField locationField;
    private JLabel locationLabel;
    private JTextField nameField;
    private JLabel nameLabel;
    private JTextField projectField;

    PraxisProjectVisualPanel1(PraxisProjectWizardPanel1 wizardPanel) {
        this.wizardPanel = wizardPanel;
        this.initComponents();
        this.fileChooser = new FileChooserBuilder(PraxisProjectWizardIterator.class).setDirectoriesOnly(true).setApproveText("Select").setDefaultWorkingDirectory(ProjectChooser.getProjectsFolder()).forceUseOfDefaultWorkingDirectory(true).setFileHiding(true);
        this.location = this.fileChooser.createFileChooser().getCurrentDirectory();
        this.locationField.setText(this.location.toString());
        this.projectField.setText(this.location.toString());
        this.nameField.getDocument().addDocumentListener(this);
    }

    @Override
    public String getName() {
        return "Project Location";
    }

    private void initComponents() {
        this.nameField = new JTextField();
        this.nameLabel = new JLabel();
        this.locationField = new JTextField();
        this.locationLabel = new JLabel();
        this.browseButton = new JButton();
        this.projectField = new JTextField();
        this.folderLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NbBundle.getMessage(PraxisProjectVisualPanel1.class, (String)"PraxisProjectVisualPanel1.nameLabel.text"));
        this.locationField.setEditable(false);
        Mnemonics.setLocalizedText((JLabel)this.locationLabel, (String)NbBundle.getMessage(PraxisProjectVisualPanel1.class, (String)"PraxisProjectVisualPanel1.locationLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(PraxisProjectVisualPanel1.class, (String)"PraxisProjectVisualPanel1.browseButton.text"));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PraxisProjectVisualPanel1.this.browseButtonActionPerformed(evt);
            }
        });
        this.projectField.setEditable(false);
        Mnemonics.setLocalizedText((JLabel)this.folderLabel, (String)NbBundle.getMessage(PraxisProjectVisualPanel1.class, (String)"PraxisProjectVisualPanel1.folderLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(25, 25, 25).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.folderLabel).addComponent(this.locationLabel).addComponent(this.nameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.projectField, GroupLayout.Alignment.LEADING, -1, 358, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.locationField, -1, 278, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseButton)).addComponent(this.nameField, -1, 358, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameField, -2, -1, -2).addComponent(this.nameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.locationField, -2, -1, -2).addComponent(this.browseButton).addComponent(this.locationLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.projectField, -2, -1, -2).addComponent(this.folderLabel)).addContainerGap(193, Short.MAX_VALUE)));
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        File loc = this.fileChooser.showOpenDialog();
        if (loc != null) {
            this.location = loc;
            this.locationField.setText(this.location.toString());
            this.update();
        }
    }

    File getProjectLocation() {
        return this.location;
    }

    String getProjectName() {
        return this.nameField.getText();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.update();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.update();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.update();
    }

    private void update() {
        this.projectField.setText(this.locationField.getText() + "/" + this.nameField.getText());
        this.wizardPanel.validate();
    }
}

