/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.project.wizard;

import java.awt.Component;
import java.io.File;
import java.util.regex.Pattern;
import javax.swing.event.ChangeListener;
import org.openide.WizardDescriptor;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.praxislive.ide.project.wizard.PraxisProjectVisualPanel1;

class PraxisProjectWizardPanel1
implements WizardDescriptor.Panel {
    public static final Pattern VALID_NAME = Pattern.compile("[ a-zA-Z0-9_-]+");
    private PraxisProjectVisualPanel1 component;
    private ChangeSupport cs = new ChangeSupport((Object)this);
    private boolean valid;
    private File project;
    private WizardDescriptor wizard;

    PraxisProjectWizardPanel1() {
    }

    public Component getComponent() {
        if (this.component == null) {
            this.component = new PraxisProjectVisualPanel1(this);
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean isValid() {
        return this.valid;
    }

    public final void addChangeListener(ChangeListener l) {
        this.cs.addChangeListener(l);
    }

    public final void removeChangeListener(ChangeListener l) {
        this.cs.removeChangeListener(l);
    }

    void validate() {
        boolean nowValid = false;
        this.project = null;
        File loc = this.component.getProjectLocation();
        String err = null;
        if (loc == null) {
            err = "No project location set";
        } else if (!(loc.isDirectory() && loc.exists() && loc.canWrite())) {
            err = "Project location must be an existing, writable directory";
        } else {
            String name = this.component.getProjectName();
            if (!this.isValidName(name)) {
                err = "Project name is invalid";
            } else {
                File f = new File(loc, name);
                if (f.exists()) {
                    err = "A file or directory with this name already exists.";
                } else {
                    this.project = f;
                    nowValid = true;
                }
            }
        }
        if (nowValid != this.valid) {
            this.valid = nowValid;
            this.cs.fireChange();
        }
        if (this.wizard != null) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)err);
        }
    }

    private boolean isValidName(String name) {
        if (name == null || name.isEmpty() || name.trim().isEmpty()) {
            return false;
        }
        return VALID_NAME.matcher(name).matches();
    }

    public void readSettings(Object settings) {
        if (settings instanceof WizardDescriptor) {
            this.wizard = (WizardDescriptor)settings;
        }
    }

    public void storeSettings(Object settings) {
        if (settings == this.wizard) {
            this.wizard.putProperty("ProjectDirectory", (Object)this.project);
        }
    }
}

