/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.properties;

import java.beans.PropertyEditor;
import java.util.Enumeration;
import org.openide.nodes.Node;
import org.praxislive.core.Value;
import org.praxislive.ide.core.api.Callback;
import org.praxislive.ide.core.api.Disposable;
import org.praxislive.ide.properties.EditorSupport;

public abstract class PraxisProperty<T extends Value>
extends Node.Property<T>
implements Disposable {
    private Editor editor;

    public PraxisProperty(Class<T> type) {
        super(type);
    }

    public PropertyEditor getPropertyEditor() {
        if (this.editor == null) {
            Editor ed = this.createEditor();
            if (ed == null) {
                ed = new EditorSupport();
            }
            this.editor = ed;
        }
        this.editor.setValue(this.getValue());
        return this.editor;
    }

    public boolean isActiveEditor(PropertyEditor editor) {
        if (this.editor == editor) {
            return true;
        }
        Editor ed = this.editor;
        while (ed instanceof DelegateEditor) {
            if ((ed = ((DelegateEditor)ed).getCurrentEditor()) != editor) continue;
            return true;
        }
        return false;
    }

    protected Editor createEditor() {
        return null;
    }

    public void setValue(T val) {
        throw new UnsupportedOperationException();
    }

    public void setValue(T value, Callback callback) {
        throw new UnsupportedOperationException();
    }

    public boolean canWrite() {
        return false;
    }

    public abstract T getValue();

    public Object getValue(String key) {
        Object attr;
        if (this.editor != null && (attr = this.editor.getAttribute(key)) != null) {
            return attr;
        }
        return super.getValue(key);
    }

    public Enumeration<String> attributeNames() {
        return super.attributeNames();
    }

    public void dispose() {
        if (this.editor != null) {
            this.editor.reset();
        }
    }

    public static interface Editor
    extends PropertyEditor {
        public String getPraxisInitializationString();

        public Object getAttribute(String var1);

        public String[] getAttributeKeys();

        public void reset();
    }

    public static interface DelegateEditor
    extends Editor {
        public Editor getCurrentEditor();
    }

    public static interface SubCommandEditor
    extends Editor {
        public void setFromCommand(String var1) throws Exception;

        public String[] getSupportedCommands();
    }
}

