/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.properties;

public class SyntaxUtils {
    private SyntaxUtils() {
    }

    public static String escape(String input) {
        String res = SyntaxUtils.doPlain(input);
        if (res == null) {
            res = SyntaxUtils.doQuoted(input);
        }
        return res;
    }

    public static String escapeQuoted(String input) {
        String res = SyntaxUtils.doQuoted(input);
        return res;
    }

    @Deprecated
    public static String escapeBraced(String input) {
        return SyntaxUtils.doBraced(input);
    }

    private static String doPlain(String input) {
        int len = input.length();
        if (len == 0 || len > 128) {
            return null;
        }
        if (input.startsWith(".")) {
            return null;
        }
        for (int i = 0; i < len; ++i) {
            char c = input.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '.' || c == '-' || c == '_') continue;
            return null;
        }
        return input;
    }

    private static String doQuoted(String input) {
        int len = input.length();
        if (len == 0) {
            return "\"\"";
        }
        StringBuilder sb = new StringBuilder(len * 2);
        sb.append("\"");
        block5: for (int i = 0; i < len; ++i) {
            char c = input.charAt(i);
            switch (c) {
                case '[': 
                case ']': 
                case '{': 
                case '}': {
                    sb.append('\\');
                    sb.append(c);
                    continue block5;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block5;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block5;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        sb.append("\"");
        return sb.toString();
    }

    private static String doBraced(String input) {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            switch (c) {
                case '\\': 
                case '{': 
                case '}': {
                    sb.append('\\');
                }
            }
            sb.append(c);
        }
        sb.append('}');
        return sb.toString();
    }
}

