/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxj;

import java.awt.EventQueue;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.netbeans.api.actions.Openable;
import org.netbeans.api.actions.Savable;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.praxislive.core.ArgumentInfo;
import org.praxislive.core.ControlAddress;
import org.praxislive.core.Value;
import org.praxislive.core.types.PArray;
import org.praxislive.ide.code.api.ClassBodyWrapper;
import org.praxislive.ide.code.api.DynamicPaths;
import org.praxislive.ide.code.api.SharedCodeInfo;
import org.praxislive.ide.model.HubProxy;
import org.praxislive.ide.model.RootProxy;
import org.praxislive.ide.project.api.PraxisProject;

public class PXJDataObject
extends MultiDataObject {
    static final String PXJ_DOB_KEY = "PXJ_DOB";
    static final String CONTROL_ADDRESS_KEY = "controlAddress";
    static final String PROJECT_KEY = "project";
    private static final String ARGUMENT_INFO_KEY = "argumentInfo";
    private static final String BASE_CLASS_KEY = "base-class";
    private static final String BASE_IMPORTS_KEY = "base-imports";
    private static final String NEW_LINE = "\n";
    private final FileObject pxjFile;
    private final String baseClassName;
    private final List<String> baseImports;
    private final ControlAddress controlAddress;
    private final PraxisProject project;
    private FileObject javaProxy;
    private DynamicPaths.Key pathsKey;
    private String defaultImports;
    private String classDeclaration;
    private final String classEnding;
    private String superClassName;
    private boolean inRefresh;

    public PXJDataObject(FileObject f, MultiFileLoader loader) throws DataObjectExistsException, IOException {
        super(f, loader);
        this.pxjFile = f;
        Object attr = f.getAttribute(ARGUMENT_INFO_KEY);
        if (attr instanceof ArgumentInfo) {
            ArgumentInfo info = (ArgumentInfo)attr;
            this.baseClassName = Optional.ofNullable(info.properties().get(BASE_CLASS_KEY)).map(Value::toString).orElse("java.lang.Object");
            this.baseImports = Optional.ofNullable(info.properties().get(BASE_IMPORTS_KEY)).flatMap(PArray::from).orElse(PArray.EMPTY).stream().map(Value::toString).collect(Collectors.toUnmodifiableList());
        } else {
            this.baseClassName = "java.lang.Object";
            this.baseImports = List.of();
        }
        attr = f.getAttribute(CONTROL_ADDRESS_KEY);
        this.controlAddress = attr instanceof ControlAddress ? (ControlAddress)attr : null;
        attr = f.getAttribute(PROJECT_KEY);
        this.project = attr instanceof PraxisProject ? (PraxisProject)attr : null;
        this.getCookieSet().add((Node.Cookie)new Open());
        this.classEnding = PXJDataObject.constructClassEnding();
    }

    protected int associateLookup() {
        return 1;
    }

    private void openProxy() {
        try {
            DataObject dob;
            Openable openable;
            if (this.javaProxy == null) {
                this.javaProxy = this.constructProxy();
                this.pathsKey = DynamicPaths.getDefault().register(this.project, this.javaProxy.getFileSystem().getRoot(), this.findSharedInfo());
            }
            if ((openable = (Openable)(dob = DataObject.find((FileObject)this.javaProxy)).getLookup().lookup(Openable.class)) != null) {
                openable.open();
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private SharedCodeInfo findSharedInfo() {
        RootProxy root;
        HubProxy hub = (HubProxy)this.project.getLookup().lookup(HubProxy.class);
        if (hub != null && (root = hub.getRoot(this.controlAddress.component().rootID())) != null) {
            return (SharedCodeInfo)root.getLookup().lookup(SharedCodeInfo.class);
        }
        return null;
    }

    protected void dispose() {
        super.dispose();
        this.disposeProxy();
    }

    void disposeProxy() {
        if (this.javaProxy != null && !this.inRefresh) {
            try {
                this.pathsKey.unregister();
                this.pathsKey = null;
                FileObject file = this.javaProxy;
                this.javaProxy = null;
                this.closeEditors(file);
                file.delete();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void closeEditors(FileObject file) {
        try {
            EditorCookie editor;
            DataObject dob = DataObject.find((FileObject)file);
            Savable savable = (Savable)dob.getLookup().lookup(Savable.class);
            if (savable != null) {
                savable.save();
            }
            if ((editor = (EditorCookie)dob.getLookup().lookup(EditorCookie.class)) != null) {
                editor.close();
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void refreshDataFromProxy() {
        try {
            int lastFold;
            if (this.javaProxy == null) {
                return;
            }
            Object data = this.javaProxy.asText();
            if (this.superClassName != null) {
                data = "extends " + this.superClassName + ";\n" + (String)data;
            }
            if (this.defaultImports != null && !this.defaultImports.isEmpty()) {
                data = ((String)data).replace(this.defaultImports + NEW_LINE, "");
                data = ((String)data).replace(this.defaultImports, "");
            }
            if (this.classDeclaration != null) {
                data = ((String)data).replace(this.classDeclaration, "");
            }
            if ((lastFold = ((String)data).lastIndexOf("}")) > 0) {
                data = ((String)data).substring(0, lastFold);
            }
            try (OutputStreamWriter writer = new OutputStreamWriter(this.pxjFile.getOutputStream());){
                writer.append((CharSequence)data);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private FileObject constructProxy() throws Exception {
        FileSystem fs = FileUtil.createMemoryFileSystem();
        FileObject f = fs.getRoot().createData(this.pxjFile.getName(), "java");
        try (OutputStreamWriter writer = new OutputStreamWriter(f.getOutputStream());){
            writer.append(this.constructProxyContent(this.pxjFile.asText(), false));
        }
        f.setAttribute(PXJ_DOB_KEY, (Object)this);
        f.setAttribute(PROJECT_KEY, (Object)this.project);
        f.setAttribute(CONTROL_ADDRESS_KEY, (Object)this.controlAddress);
        f.addFileChangeListener((FileChangeListener)new ProxyListener());
        return f;
    }

    private String constructProxyContent(String source, boolean ignoreExtends) {
        this.defaultImports = null;
        this.classDeclaration = null;
        return ClassBodyWrapper.create().className(this.pxjFile.getName()).extendsType(this.superClassName == null ? this.baseClassName : this.superClassName).defaultImports(this.baseImports).ignoreExtends(ignoreExtends).filter(new ClassBodyWrapper.Filter(){

            public void writeDefaultImports(StringBuilder sb, List<String> imports) {
                PXJDataObject.this.defaultImports = PXJDataObject.constructDefaultImports(imports);
                sb.append(PXJDataObject.this.defaultImports);
            }

            public void writeClassDeclaration(StringBuilder sb, String className, String extendedType, List<String> implementedTypes) {
                PXJDataObject.this.superClassName = extendedType.equals(PXJDataObject.this.baseClassName) ? null : extendedType;
                sb.append(PXJDataObject.NEW_LINE);
                PXJDataObject.this.classDeclaration = PXJDataObject.constructClassDeclaration(className, extendedType);
                sb.append(PXJDataObject.this.classDeclaration);
            }

            public void writeClassEnding(StringBuilder sb) {
                sb.append(PXJDataObject.this.classEnding);
            }
        }).wrap(source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshProxy() {
        if (this.javaProxy == null) {
            assert (false);
            return;
        }
        this.inRefresh = true;
        this.closeEditors(this.javaProxy);
        try (OutputStreamWriter writer = new OutputStreamWriter(this.javaProxy.getOutputStream());){
            writer.append(this.constructProxyContent(this.pxjFile.asText(), true));
            EventQueue.invokeLater(this::openProxy);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            this.inRefresh = false;
        }
    }

    void setBaseType(String baseType) {
        String type;
        String string = type = baseType == null ? this.baseClassName : baseType.strip();
        if (type.isBlank() || type.equals(this.baseClassName)) {
            if (this.superClassName != null) {
                this.superClassName = null;
                this.refreshProxy();
            }
        } else if (!type.equals(this.superClassName)) {
            this.superClassName = type;
            this.refreshProxy();
        }
    }

    String getBaseType() {
        return this.superClassName;
    }

    private static String constructDefaultImports(List<String> imports) {
        if (!imports.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("//<editor-fold defaultstate=\"collapsed\" desc=\"Default Imports\">");
            sb.append("//GEN-BEGIN:imports");
            imports.forEach(i -> sb.append(NEW_LINE).append("import ").append((String)i).append(";"));
            sb.append("//</editor-fold> --//GEN-END:imports").append(NEW_LINE);
            return sb.toString();
        }
        return "";
    }

    private static String constructClassDeclaration(String className, String superclass) {
        StringBuilder sb = new StringBuilder();
        sb.append("//<editor-fold defaultstate=\"collapsed\" desc=\"Class Declaration\">");
        sb.append("//GEN-BEGIN:classdec").append(NEW_LINE);
        sb.append("class ");
        sb.append(className);
        sb.append(" extends ");
        sb.append(superclass);
        sb.append(" {").append(NEW_LINE);
        sb.append("//</editor-fold> --//GEN-END:classdec").append(NEW_LINE);
        return sb.toString();
    }

    private static String constructClassEnding() {
        return "}//GEN-BEGIN:classend\n//GEN-END:classend";
    }

    private class Open
    implements OpenCookie {
        private Open() {
        }

        public void open() {
            PXJDataObject.this.openProxy();
        }
    }

    private class ProxyListener
    extends FileChangeAdapter {
        private ProxyListener() {
        }

        public void fileChanged(FileEvent fe) {
            if (fe.getFile() == PXJDataObject.this.javaProxy) {
                PXJDataObject.this.refreshDataFromProxy();
            } else {
                fe.getFile().removeFileChangeListener((FileChangeListener)this);
            }
        }
    }
}

