/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxj;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Optional;
import org.netbeans.api.project.Project;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Children;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;
import org.openide.nodes.NodeListener;
import org.openide.util.Lookup;
import org.openide.util.lookup.ProxyLookup;
import org.praxislive.core.ControlAddress;
import org.praxislive.ide.model.HubProxy;
import org.praxislive.ide.model.Proxy;
import org.praxislive.ide.pxj.PXJavaEditorSupport;

class PXJavaDataObject
extends MultiDataObject {
    private final ControlAddress controlAddress;
    private final Project project;

    public PXJavaDataObject(FileObject fo, MultiFileLoader loader) throws DataObjectExistsException {
        super(fo, loader);
        CookieSet cookies = this.getCookieSet();
        cookies.add((Node.Cookie)new PXJavaEditorSupport(this, cookies));
        this.controlAddress = (ControlAddress)fo.getAttribute("controlAddress");
        this.project = (Project)fo.getAttribute("project");
    }

    protected int associateLookup() {
        return 1;
    }

    protected Node createNodeDelegate() {
        Node cmpNode = Optional.ofNullable((HubProxy)this.project.getLookup().lookup(HubProxy.class)).flatMap(hub -> hub.find(this.controlAddress.component())).map(Proxy::getNodeDelegate).orElse(null);
        return new PXJavaNode(this, cmpNode);
    }

    private static class PXJavaNode
    extends DataNode {
        Node componentNode;
        ComponentListener cmpL;
        ComponentNodeListener cmpNL;

        private PXJavaNode(PXJavaDataObject dob, Node componentNode) {
            super((DataObject)dob, Children.LEAF, (Lookup)(componentNode == null ? dob.getLookup() : new ProxyLookup(new Lookup[]{dob.getLookup(), componentNode.getLookup()})));
            this.componentNode = componentNode;
            if (componentNode != null) {
                this.cmpL = new ComponentListener();
                this.cmpNL = new ComponentNodeListener();
                componentNode.addPropertyChangeListener((PropertyChangeListener)this.cmpL);
                componentNode.addNodeListener((NodeListener)this.cmpNL);
            }
        }

        public Node.PropertySet[] getPropertySets() {
            if (this.componentNode != null) {
                return this.componentNode.getPropertySets();
            }
            return super.getPropertySets();
        }

        public void destroy() throws IOException {
            super.destroy();
            if (this.componentNode != null) {
                this.componentNode.removePropertyChangeListener((PropertyChangeListener)this.cmpL);
                this.componentNode.removeNodeListener((NodeListener)this.cmpNL);
                this.componentNode = null;
                this.cmpL = null;
                this.cmpNL = null;
            }
        }

        class ComponentListener
        implements PropertyChangeListener {
            ComponentListener() {
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PXJavaNode.this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
            }
        }

        class ComponentNodeListener
        extends NodeAdapter {
            ComponentNodeListener() {
            }

            public void propertyChange(PropertyChangeEvent evt) {
                if ("propertySets".equals(evt.getPropertyName())) {
                    PXJavaNode.this.firePropertySetsChange(null, null);
                }
            }
        }
    }
}

