/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxj;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.praxislive.ide.pxj.Bundle;
import org.praxislive.ide.pxj.PXJDataObject;

public class ChangeBaseTypeAction
extends AbstractAction
implements ContextAwareAction {
    private final PXJDataObject pxjDob;

    public ChangeBaseTypeAction() {
        this.pxjDob = null;
        this.setEnabled(false);
        this.putValue("hideWhenDisabled", true);
    }

    public ChangeBaseTypeAction(PXJDataObject pxjDob) {
        super(Bundle.LBL_changeBaseTypeAction());
        this.pxjDob = pxjDob;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        assert (this.pxjDob != null);
        if (this.pxjDob == null) {
            return;
        }
        String baseType = this.pxjDob.getBaseType();
        if (baseType == null) {
            baseType = "";
        }
        NotifyDescriptor.InputLine input = new NotifyDescriptor.InputLine(Bundle.LBL_baseType(), Bundle.TITLE_baseType());
        input.setInputText(baseType);
        Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)input);
        if (result == NotifyDescriptor.OK_OPTION) {
            this.pxjDob.setBaseType(input.getInputText().strip());
        }
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        Object attr;
        FileObject file = (FileObject)actionContext.lookup(FileObject.class);
        if (file != null && (attr = file.getAttribute("PXJ_DOB")) instanceof PXJDataObject) {
            return new ChangeBaseTypeAction((PXJDataObject)((Object)attr));
        }
        return this;
    }
}

