/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxj;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.core.api.multiview.MultiViews;
import org.netbeans.spi.editor.guards.GuardedEditorSupport;
import org.netbeans.spi.editor.guards.GuardedSectionsFactory;
import org.netbeans.spi.editor.guards.GuardedSectionsProvider;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.windows.CloneableOpenSupport;
import org.praxislive.ide.pxj.PXJDataObject;
import org.praxislive.ide.pxj.PXJavaDataObject;

class PXJavaEditorSupport
extends DataEditorSupport
implements OpenCookie,
EditCookie,
EditorCookie.Observable,
LineCookie {
    private static final Logger LOG = Logger.getLogger(PXJavaEditorSupport.class.getName());
    private final PXJavaDataObject dob;
    private final CookieSet cookies;
    private final SaveImpl saveCookie;
    private GuardedEditor guardedEditor;
    private GuardedSectionsProvider guardedProvider;

    PXJavaEditorSupport(PXJavaDataObject dob, CookieSet cookies) {
        super((DataObject)dob, dob.getLookup(), (CloneableEditorSupport.Env)new Env((DataObject)dob));
        this.dob = dob;
        this.cookies = cookies;
        this.saveCookie = new SaveImpl();
    }

    protected boolean notifyModified() {
        if (!super.notifyModified()) {
            return false;
        }
        this.addSaveCookie();
        return true;
    }

    protected void notifyUnmodified() {
        super.notifyUnmodified();
        this.removeSaveCookie();
    }

    private void addSaveCookie() {
        if (this.dob.getCookie(SaveCookie.class) == null) {
            this.cookies.add((Node.Cookie)this.saveCookie);
            this.dob.setModified(true);
        }
    }

    private void removeSaveCookie() {
        SaveCookie cookie = (SaveCookie)this.dob.getCookie(SaveCookie.class);
        if (cookie == this.saveCookie) {
            this.cookies.remove((Node.Cookie)this.saveCookie);
            this.dob.setModified(false);
        }
    }

    protected void notifyClosed() {
        LOG.fine("notifyClosed() called on PXJavaEditorSupport");
        super.notifyClosed();
        this.env.unmarkModified();
        Object pxj = this.dob.getPrimaryFile().getAttribute("PXJ_DOB");
        if (pxj instanceof PXJDataObject) {
            LOG.fine("disposing proxy on PXJDataObject");
            ((PXJDataObject)((Object)pxj)).disposeProxy();
        }
    }

    protected CloneableEditorSupport.Pane createPane() {
        DataObject dobj = this.getDataObject();
        if (dobj == null || !dobj.isValid()) {
            return super.createPane();
        }
        return (CloneableEditorSupport.Pane)MultiViews.createCloneableMultiView((String)"text/x-java", (Serializable)this.getDataObject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadFromStreamToKit(StyledDocument doc, InputStream stream, EditorKit kit) throws IOException, BadLocationException {
        LOG.fine("Loading PXJ Java proxy with guarded sections");
        FileObject file = this.dob.getPrimaryFile();
        if (this.guardedEditor == null) {
            this.guardedEditor = new GuardedEditor();
            GuardedSectionsFactory factory = GuardedSectionsFactory.find((String)"text/x-java");
            if (factory != null) {
                LOG.fine("Found GuardedSectionsFactory");
                this.guardedProvider = factory.create((GuardedEditorSupport)this.guardedEditor);
            }
        }
        if (this.guardedProvider != null) {
            LOG.fine("Loading file through GuardedSectionsProvider");
            this.guardedEditor.doc = doc;
            Charset c = FileEncodingQuery.getEncoding((FileObject)file);
            try (Reader reader = this.guardedProvider.createGuardedReader(stream, c);){
                kit.read(reader, (Document)doc, 0);
            }
        } else {
            super.loadFromStreamToKit(doc, stream, kit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveFromKitToStream(StyledDocument doc, EditorKit kit, OutputStream stream) throws IOException, BadLocationException {
        if (this.guardedProvider != null) {
            Charset c = FileEncodingQuery.getEncoding((FileObject)this.getDataObject().getPrimaryFile());
            try (Writer writer = this.guardedProvider.createGuardedWriter(stream, c);){
                kit.write(writer, (Document)doc, 0, doc.getLength());
            }
        } else {
            super.saveFromKitToStream(doc, kit, stream);
        }
    }

    private static class Env
    extends DataEditorSupport.Env {
        private Env(DataObject obj) {
            super(obj);
        }

        protected FileObject getFile() {
            return this.getDataObject().getPrimaryFile();
        }

        protected FileLock takeLock() throws IOException {
            return this.getFile().lock();
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return (CloneableOpenSupport)this.getDataObject().getCookie(PXJavaEditorSupport.class);
        }
    }

    private class SaveImpl
    implements SaveCookie {
        private SaveImpl() {
        }

        public void save() throws IOException {
            PXJavaEditorSupport.this.saveDocument();
        }
    }

    private static class GuardedEditor
    implements GuardedEditorSupport {
        private StyledDocument doc;

        private GuardedEditor() {
        }

        public StyledDocument getDocument() {
            return this.doc;
        }
    }
}

