/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr.graph.scene;

import java.awt.Color;
import java.awt.Dimension;
import java.util.Objects;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.Widget;
import org.praxislive.ide.pxr.graph.scene.PraxisGraphScene;

class CommentWidget
extends Widget {
    private final PraxisGraphScene<?> scene;
    private String text;

    public CommentWidget(PraxisGraphScene<?> scene) {
        super(scene);
        this.scene = scene;
        this.setLayout(LayoutFactory.createVerticalFlowLayout());
        this.setMinimumSize(new Dimension(100, 10));
        this.text = "";
    }

    public final void setText(String text) {
        if (this.text.equals(text)) {
            return;
        }
        this.text = Objects.requireNonNull(text);
        String[] lines = text.split("\n");
        this.removeChildren();
        for (String line : lines) {
            LabelWidget lw = new LabelWidget(this.getScene(), line);
            lw.setOpaque(false);
            lw.setForeground(Color.BLACK);
            this.addChild((Widget)lw);
        }
        this.scene.revalidate();
    }

    public final String getText() {
        return this.text;
    }

    protected void paintChildren() {
        if (this.scene.isBelowLODThreshold()) {
            return;
        }
        super.paintChildren();
    }
}

