/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr.graph.scene;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.util.List;
import java.util.Objects;
import org.netbeans.api.visual.anchor.Anchor;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.Scene;
import org.praxislive.ide.pxr.graph.scene.LAFScheme;
import org.praxislive.ide.pxr.graph.scene.PinWidget;
import org.praxislive.ide.pxr.graph.scene.PraxisGraphScene;

public class EdgeWidget
extends ConnectionWidget {
    private final PraxisGraphScene scene;
    private final SceneListenerImpl sceneListener;
    PinWidget srcPin;
    PinWidget dstPin;
    private LAFScheme scheme;
    private LAFScheme.Colors schemeColors;

    public EdgeWidget(PraxisGraphScene scene, PinWidget srcPin, PinWidget dstPin) {
        super((Scene)scene);
        this.scene = scene;
        this.sceneListener = new SceneListenerImpl();
        this.scheme = scene.getLookAndFeel();
        this.srcPin = Objects.requireNonNull(srcPin);
        this.dstPin = Objects.requireNonNull(dstPin);
        this.scheme.installUI(this);
    }

    EdgeWidget(PraxisGraphScene scene) {
        super((Scene)scene);
        this.scene = scene;
        this.sceneListener = new SceneListenerImpl();
        this.scheme = scene.getLookAndFeel();
        this.scheme.installUI(this);
    }

    protected void notifyAdded() {
        this.scene.addSceneListener(this.sceneListener);
    }

    protected void notifyRemoved() {
        this.scene.removeSceneListener(this.sceneListener);
    }

    void setSchemeColors(LAFScheme.Colors colors) {
        this.schemeColors = colors;
        this.revalidate();
    }

    LAFScheme.Colors getSchemeColors() {
        if (this.schemeColors == null) {
            if (this.srcPin == null) {
                return this.scene.getSchemeColors();
            }
            return this.srcPin.getSchemeColors();
        }
        return this.schemeColors;
    }

    public void notifyStateChanged(ObjectState previousState, ObjectState state) {
        if (!previousState.isSelected() && state.isSelected()) {
            this.bringToFront();
        } else if (!previousState.isHovered() && state.isHovered()) {
            this.bringToFront();
        }
        this.scheme.updateUI(this);
    }

    protected Rectangle calculateClientArea() {
        if (this.scene.isOrthogonalRouting()) {
            return super.calculateClientArea();
        }
        GeneralPath path = this.generatePath(this.getControlPoints());
        if (path == null) {
            return new Rectangle();
        }
        Rectangle bounds = this.generatePath(this.getControlPoints()).getBounds();
        bounds.grow(4, 4);
        return bounds;
    }

    public boolean isHitAt(Point localLocation) {
        if (this.scene.isOrthogonalRouting()) {
            return super.isHitAt(localLocation);
        }
        if (!this.isVisible()) {
            return false;
        }
        GeneralPath path = this.generatePath(this.getControlPoints());
        Rectangle localArea = new Rectangle(localLocation.x - 3, localLocation.y - 3, 6, 6);
        return path.intersects(localArea);
    }

    protected void paintWidget() {
        if (this.scene.isOrthogonalRouting()) {
            super.paintWidget();
            return;
        }
        Graphics2D gr = this.getGraphics();
        gr.setColor(this.getForeground());
        List points = this.getControlPoints();
        GeneralPath path = this.generatePath(points);
        if (path != null) {
            Stroke previousStroke = gr.getStroke();
            gr.setPaint(this.getForeground());
            gr.setStroke(this.getStroke());
            gr.draw(path);
            gr.setStroke(previousStroke);
        }
        int last = points.size() - 1;
        for (int index = 0; index <= last; ++index) {
            Point point = (Point)points.get(index);
            AffineTransform previousTransform = gr.getTransform();
            gr.translate(point.x, point.y);
            if (index == 0 || index == last) {
                this.getEndPointShape().paint(gr);
            } else {
                this.getControlPointShape().paint(gr);
            }
            gr.setTransform(previousTransform);
        }
    }

    private GeneralPath generatePath(List<Point> points) {
        if (points.isEmpty()) {
            return null;
        }
        boolean sourceRight = this.getSourceAnchor().compute(this.getSourceAnchorEntry()).getDirections().contains(Anchor.Direction.RIGHT);
        boolean targetRight = !sourceRight;
        GeneralPath path = new GeneralPath();
        Point sourcePoint = points.get(0);
        Point targetPoint = points.get(points.size() - 1);
        path.moveTo(sourcePoint.x, sourcePoint.y);
        double diffX = Math.abs(sourcePoint.x - targetPoint.x);
        diffX = Math.min(diffX, 200.0);
        diffX = Math.max(diffX, 20.0);
        double diffY = (double)Math.abs(sourcePoint.y - targetPoint.y) * 0.1;
        diffY = Math.min(diffY, 10.0);
        path.curveTo((double)sourcePoint.x + (sourceRight ? diffX : -diffX), (double)sourcePoint.y - diffY, (double)targetPoint.x + (targetRight ? diffX : -diffX), (double)targetPoint.y + diffY, (double)targetPoint.x, (double)targetPoint.y);
        return path;
    }

    private class SceneListenerImpl
    implements Scene.SceneListener {
        private SceneListenerImpl() {
        }

        public void sceneRepaint() {
        }

        public void sceneValidating() {
            EdgeWidget.this.scheme.updateUI(EdgeWidget.this);
        }

        public void sceneValidated() {
        }
    }
}

