/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr.graph.scene;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Image;
import java.util.Objects;
import org.netbeans.api.visual.anchor.AnchorShape;
import org.netbeans.api.visual.anchor.PointShape;
import org.netbeans.api.visual.anchor.PointShapeFactory;
import org.netbeans.api.visual.border.Border;
import org.netbeans.api.visual.border.BorderFactory;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.widget.Widget;
import org.openide.util.ImageUtilities;
import org.praxislive.ide.pxr.graph.scene.EdgeWidget;
import org.praxislive.ide.pxr.graph.scene.NodeWidget;
import org.praxislive.ide.pxr.graph.scene.PinWidget;

public class LAFScheme {
    static Color OFF_WHITE = new Color(241, 249, 253);
    private static final Color DARK_GREY = Color.decode("#191919");
    private static final Border BORDER_MINIMIZE = BorderFactory.createOpaqueBorder((int)2, (int)2, (int)2, (int)2);
    private static final PointShape POINT_SHAPE_IMAGE = PointShapeFactory.createImagePointShape((Image)ImageUtilities.loadImage((String)"org/praxislive/ide/pxr/graph/scene/resources/vmd-pin.png"));
    private static final Colors DEFAULT_RESOURCES = new Colors(new Color(7638208), new Color(12242416));

    protected void installUI(NodeWidget widget) {
        widget.setOpaque(false);
        widget.getHeader().setOpaque(false);
        widget.getMinimizeButton().setBorder(BORDER_MINIMIZE);
        this.updateUI(widget);
    }

    protected void updateUI(NodeWidget widget) {
        ObjectState state = widget.getState();
        Colors colors = widget.getSchemeColors();
        if (colors == null) {
            colors = DEFAULT_RESOURCES;
        }
        if (widget.isBelowLODThreshold()) {
            if (state.isSelected()) {
                if (state.isFocused()) {
                    widget.setBorder(colors.BORDER_SMALL_NODE_SELECTED_FOCUSED);
                } else {
                    widget.setBorder(colors.BORDER_SMALL_NODE_SELECTED);
                }
            } else if (state.isFocused()) {
                widget.setBorder(colors.BORDER_SMALL_NODE_FOCUSED);
            } else {
                widget.setBorder(colors.BORDER_SMALL_NODE);
            }
        } else if (state.isSelected()) {
            if (state.isFocused()) {
                widget.setBorder(colors.BORDER_NODE_SELECTED_FOCUSED);
            } else {
                widget.setBorder(colors.BORDER_NODE_SELECTED);
            }
        } else if (state.isFocused()) {
            widget.setBorder(colors.BORDER_NODE_FOCUSED);
        } else {
            widget.setBorder(colors.BORDER_NODE);
        }
        Widget header = widget.getHeader();
        header.setBorder(state.isSelected() || state.isHovered() ? colors.BORDER_HEADER_SELECTED : colors.BORDER_HEADER);
        Widget comment = widget.getCommentWidget();
        if (comment != null) {
            comment.setBorder(colors.BORDER_HEADER);
        }
    }

    protected boolean isNodeMinimizeButtonOnRight(NodeWidget widget) {
        return false;
    }

    protected Image getMinimizeWidgetImage(NodeWidget widget) {
        return widget.isMinimized() ? ImageUtilities.loadImage((String)"org/praxislive/ide/pxr/graph/scene/resources/vmd-expand.png") : ImageUtilities.loadImage((String)"org/praxislive/ide/pxr/graph/scene/resources/vmd-collapse.png");
    }

    protected void installUI(EdgeWidget widget) {
        widget.setSourceAnchorShape(AnchorShape.NONE);
        widget.setTargetAnchorShape(AnchorShape.NONE);
        widget.setPaintControlPoints(true);
        widget.setForeground(OFF_WHITE);
        this.updateUI(widget);
    }

    protected void updateUI(EdgeWidget widget) {
        ObjectState state = widget.getState();
        Colors colors = widget.getSchemeColors();
        if (colors == null) {
            colors = DEFAULT_RESOURCES;
        }
        if (state.isHovered() || state.isSelected()) {
            widget.setEndPointShape(PointShape.SQUARE_FILLED_BIG);
        } else {
            widget.setControlPointShape(PointShape.NONE);
            widget.setEndPointShape(PointShape.SQUARE_FILLED_SMALL);
        }
        if (state.isHovered() || state.isSelected()) {
            widget.bringToFront();
            widget.setForeground(colors.COLOR_SELECTED);
            widget.setStroke(new BasicStroke(4.0f));
        } else {
            widget.setForeground(colors.COLOR_SELECTED);
            widget.setStroke(new BasicStroke(2.0f));
        }
        widget.setControlPointCutDistance(5);
    }

    protected void installUI(PinWidget widget) {
        widget.setOpaque(false);
        this.updateUI(widget);
    }

    protected void updateUI(PinWidget widget) {
        ObjectState state = widget.getState();
        Colors colors = widget.getSchemeColors();
        if (colors == null) {
            colors = DEFAULT_RESOURCES;
        }
        if (state.isHovered()) {
            widget.setBorder(colors.BORDER_PIN_SELECTED);
            widget.getPinNameWidget().setForeground(colors.COLOR_NORMAL);
        } else {
            widget.setBorder(colors.BORDER_PIN);
            widget.getPinNameWidget().setForeground(colors.COLOR_NORMAL);
        }
    }

    protected int getAnchorGap() {
        return 8;
    }

    protected Color getBackgroundColor() {
        return DARK_GREY;
    }

    public static class Colors {
        private final Color COLOR_SELECTED;
        private final Color COLOR_NORMAL;
        private final Border BORDER_NODE;
        private final Border BORDER_NODE_FOCUSED;
        private final Border BORDER_NODE_SELECTED;
        private final Border BORDER_NODE_SELECTED_FOCUSED;
        private final Border BORDER_HEADER;
        private final Border BORDER_HEADER_SELECTED;
        private final Border BORDER_SMALL_NODE;
        private final Border BORDER_SMALL_NODE_FOCUSED;
        private final Border BORDER_SMALL_NODE_SELECTED;
        private final Border BORDER_SMALL_NODE_SELECTED_FOCUSED;
        private final Border BORDER_PIN;
        private final Border BORDER_PIN_SELECTED;

        public Colors(Color highlight, Color normal) {
            this.COLOR_SELECTED = Objects.requireNonNull(highlight);
            this.COLOR_NORMAL = Objects.requireNonNull(normal);
            this.BORDER_NODE = BorderFactory.createCompositeBorder((Border[])new Border[]{BorderFactory.createEmptyBorder((int)2), BorderFactory.createRoundedBorder((int)8, (int)8, (int)0, (int)0, (Color)DARK_GREY, (Color)this.COLOR_NORMAL)});
            this.BORDER_NODE_FOCUSED = BorderFactory.createCompositeBorder((Border[])new Border[]{BorderFactory.createResizeBorder((int)2, (Color)OFF_WHITE, (boolean)true), BorderFactory.createRoundedBorder((int)8, (int)8, (int)0, (int)0, (Color)DARK_GREY, (Color)this.COLOR_NORMAL)});
            this.BORDER_NODE_SELECTED = BorderFactory.createCompositeBorder((Border[])new Border[]{BorderFactory.createEmptyBorder((int)2), BorderFactory.createRoundedBorder((int)8, (int)8, (int)0, (int)0, (Color)DARK_GREY, (Color)this.COLOR_SELECTED)});
            this.BORDER_NODE_SELECTED_FOCUSED = BorderFactory.createCompositeBorder((Border[])new Border[]{BorderFactory.createResizeBorder((int)2, (Color)OFF_WHITE, (boolean)true), BorderFactory.createRoundedBorder((int)8, (int)8, (int)0, (int)0, (Color)DARK_GREY, (Color)this.COLOR_SELECTED)});
            this.BORDER_HEADER = BorderFactory.createRoundedBorder((int)8, (int)8, (int)8, (int)4, (Color)this.COLOR_NORMAL, (Color)this.COLOR_NORMAL);
            this.BORDER_HEADER_SELECTED = BorderFactory.createRoundedBorder((int)8, (int)8, (int)8, (int)4, (Color)this.COLOR_SELECTED, (Color)this.COLOR_SELECTED);
            this.BORDER_SMALL_NODE = BorderFactory.createCompositeBorder((Border[])new Border[]{BorderFactory.createEmptyBorder((int)3), BorderFactory.createRoundedBorder((int)8, (int)8, (int)0, (int)0, (Color)this.COLOR_NORMAL, null)});
            this.BORDER_SMALL_NODE_FOCUSED = BorderFactory.createCompositeBorder((Border[])new Border[]{BorderFactory.createResizeBorder((int)3, (Color)OFF_WHITE, (boolean)true), BorderFactory.createRoundedBorder((int)8, (int)8, (int)0, (int)0, (Color)this.COLOR_NORMAL, null)});
            this.BORDER_SMALL_NODE_SELECTED = BorderFactory.createCompositeBorder((Border[])new Border[]{BorderFactory.createEmptyBorder((int)3), BorderFactory.createRoundedBorder((int)8, (int)8, (int)0, (int)0, (Color)this.COLOR_SELECTED, null)});
            this.BORDER_SMALL_NODE_SELECTED_FOCUSED = BorderFactory.createCompositeBorder((Border[])new Border[]{BorderFactory.createResizeBorder((int)3, (Color)OFF_WHITE, (boolean)true), BorderFactory.createRoundedBorder((int)8, (int)8, (int)0, (int)0, (Color)this.COLOR_SELECTED, null)});
            this.BORDER_PIN = BorderFactory.createRoundedBorder((int)8, (int)8, (int)8, (int)4, null, null);
            this.BORDER_PIN_SELECTED = BorderFactory.createRoundedBorder((int)8, (int)8, (int)8, (int)4, null, (Color)this.COLOR_NORMAL);
        }
    }
}

