/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr.graph;

import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyBoundsAdapter;
import java.awt.event.HierarchyEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Locale;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;

class JSuggestField
extends JTextField {
    private static final long serialVersionUID = 1756202080423312153L;
    private Popup popup;
    private JList list;
    private Vector<String> data = new Vector();
    private Vector<String> suggestions = new Vector();
    private InterruptableMatcher matcher;
    private String lastWord = "";

    public JSuggestField() {
        this.addHierarchyBoundsListener(new HierarchyBoundsAdapter(){

            @Override
            public void ancestorMoved(HierarchyEvent e) {
                JSuggestField.this.hideSuggest();
            }

            @Override
            public void ancestorResized(HierarchyEvent e) {
                JSuggestField.this.hideSuggest();
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                JSuggestField.this.hideSuggest();
            }
        });
        this.list = new JList();
        this.list.setFocusable(false);
        this.list.addMouseListener(new MouseAdapter(){
            private int selected;

            @Override
            public void mouseReleased(MouseEvent e) {
                JSuggestField.this.setText((String)JSuggestField.this.list.getSelectedValue());
                JSuggestField.this.fireActionPerformed();
                JSuggestField.this.hideSuggest();
            }
        });
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    return;
                }
                if (e.getKeyCode() == 40) {
                    if (JSuggestField.this.isSuggestVisible()) {
                        JSuggestField.this.list.setSelectedIndex(JSuggestField.this.list.getSelectedIndex() + 1);
                        JSuggestField.this.list.ensureIndexIsVisible(JSuggestField.this.list.getSelectedIndex() + 1);
                        JSuggestField.this.setText((String)JSuggestField.this.list.getSelectedValue());
                        return;
                    }
                    JSuggestField.this.showPopup();
                    return;
                }
                if (e.getKeyCode() == 38) {
                    if (JSuggestField.this.isSuggestVisible()) {
                        JSuggestField.this.list.setSelectedIndex(JSuggestField.this.list.getSelectedIndex() - 1);
                        JSuggestField.this.list.ensureIndexIsVisible(JSuggestField.this.list.getSelectedIndex() - 1);
                        JSuggestField.this.setText((String)JSuggestField.this.list.getSelectedValue());
                    } else {
                        JSuggestField.this.showPopup();
                    }
                    return;
                }
                if ((e.getKeyCode() == 10 || e.getKeyCode() == 9) && JSuggestField.this.list.getSelectedIndex() != -1 && JSuggestField.this.suggestions.size() > 0) {
                    JSuggestField.this.setText((String)JSuggestField.this.list.getSelectedValue());
                    JSuggestField.this.hidePopup();
                    return;
                }
                JSuggestField.this.showSuggest();
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
    }

    public JSuggestField(Vector<String> data) {
        this();
        this.setSuggestData(data);
    }

    public boolean setSuggestData(Vector<String> data) {
        if (data == null) {
            return false;
        }
        this.data = data;
        this.list.setListData(data);
        this.suggestions.clear();
        return true;
    }

    public Vector<String> getSuggestData() {
        return (Vector)this.data.clone();
    }

    public void showSuggest() {
        if (!this.getText().toLowerCase().contains(this.lastWord.toLowerCase())) {
            this.suggestions.clear();
        }
        if (this.suggestions.isEmpty()) {
            this.suggestions.addAll(this.data);
        }
        if (this.matcher != null) {
            this.matcher.stop = true;
        }
        this.matcher = new InterruptableMatcher();
        SwingUtilities.invokeLater(this.matcher);
        this.lastWord = this.getText();
    }

    public void hideSuggest() {
        this.hidePopup();
    }

    private void showPopup() {
        if (this.popup != null) {
            return;
        }
        JScrollPane scroll = new JScrollPane(this.list, 20, 30);
        Dimension dim = new Dimension(this.getSize().width, Math.min(12, this.data.size()) * (this.list.getCellRenderer().getListCellRendererComponent(this.list, "XXX", (int)0, (boolean)true, (boolean)true).getPreferredSize().height + 4));
        scroll.setPreferredSize(dim);
        Point loc = this.getLocationOnScreen();
        GraphicsConfiguration gc = this.getGraphicsConfiguration();
        Rectangle screenBounds = gc.getBounds();
        Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(gc);
        int screenHeight = screenBounds.height - screenInsets.bottom;
        loc.y = (double)(loc.y + this.getHeight()) + dim.getHeight() > (double)screenHeight ? (int)((double)loc.y - dim.getHeight()) : (loc.y += this.getHeight());
        this.popup = PopupFactory.getSharedInstance().getPopup(this, scroll, loc.x, loc.y);
        this.popup.show();
    }

    private void hidePopup() {
        if (this.popup != null) {
            this.popup.hide();
            this.popup = null;
        }
    }

    private boolean isSuggestVisible() {
        return this.popup != null;
    }

    @Override
    protected void fireActionPerformed() {
        if (this.matcher != null) {
            this.matcher.stop = true;
            this.matcher = null;
        }
        super.fireActionPerformed();
    }

    private class InterruptableMatcher
    implements Runnable {
        private boolean stop;

        private InterruptableMatcher() {
        }

        @Override
        public void run() {
            if (this.stop || !JSuggestField.this.isVisible()) {
                return;
            }
            try {
                String word = JSuggestField.this.getText().toLowerCase(Locale.ROOT);
                JSuggestField.this.suggestions.clear();
                JSuggestField.this.data.forEach(datum -> {
                    if (datum.toLowerCase(Locale.ROOT).startsWith(word)) {
                        JSuggestField.this.suggestions.add((String)datum);
                    }
                });
                JSuggestField.this.data.forEach(datum -> {
                    String lower = datum.toLowerCase(Locale.ROOT);
                    if (!lower.startsWith(word) && lower.contains(word)) {
                        JSuggestField.this.suggestions.add((String)datum);
                    }
                });
                if (JSuggestField.this.suggestions.size() > 0) {
                    JSuggestField.this.list.setListData(JSuggestField.this.suggestions);
                    JSuggestField.this.showPopup();
                    JSuggestField.this.list.setSelectedIndex(0);
                    JSuggestField.this.list.ensureIndexIsVisible(0);
                } else {
                    JSuggestField.this.hidePopup();
                }
            }
            catch (Exception ex) {
                Logger.getLogger(JSuggestField.class.getName()).log(Level.WARNING, "Error in matcher", ex);
            }
        }
    }
}

