/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr.graph;

import java.awt.Point;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.stream.Stream;
import org.praxislive.core.Value;
import org.praxislive.core.types.PMap;
import org.praxislive.ide.pxr.graph.GraphEditor;
import org.praxislive.ide.pxr.spi.ModelTransform;
import org.praxislive.project.GraphBuilder;
import org.praxislive.project.GraphElement;
import org.praxislive.project.GraphModel;

abstract sealed class PositionTransform {
    private static final String META = "meta";
    final GraphEditor editor;

    PositionTransform(GraphEditor editor) {
        this.editor = editor;
    }

    List<Point> findPositions(GraphModel model) {
        return model.root().children().values().stream().flatMap(c -> this.findPosition((GraphElement.Component)c).stream()).toList();
    }

    Optional<Point> findPosition(GraphElement.Component cmp) {
        return Optional.ofNullable((GraphElement.Property)cmp.properties().get(META)).flatMap(p -> PMap.from((Value)p.value())).filter(m -> m.keys().containsAll(List.of("graph.x", "graph.y"))).map(m -> new Point(m.getInt("graph.x", 0), m.getInt("graph.y", 0)));
    }

    GraphModel offset(GraphModel model, Point offset) {
        return model.withTransform(r -> r.transformChildren(children -> children.map(e -> Map.entry((String)e.getKey(), this.offset((GraphElement.Component)e.getValue(), offset))).toList()));
    }

    private GraphElement.Component offset(GraphElement.Component cmp, Point offset) {
        GraphBuilder.Component builder = GraphBuilder.component((GraphElement.Component)cmp);
        GraphElement.Property metaProp = (GraphElement.Property)builder.properties().get(META);
        if (metaProp != null) {
            PMap existing = PMap.from((Value)metaProp.value()).orElse(PMap.EMPTY);
            int x = existing.getInt("graph.x", 0) + offset.x;
            int y = existing.getInt("graph.y", 0) + offset.y;
            PMap meta = PMap.merge((PMap)existing, (PMap)PMap.of((String)"graph.x", (Object)x, (String)"graph.y", (Object)y), (BinaryOperator)PMap.REPLACE);
            builder.transformProperties(props -> props.map(e -> META.equals(e.getKey()) ? Map.entry(META, GraphElement.property((Value)meta)) : e).toList());
        } else {
            PMap meta = PMap.of((String)"graph.x", (Object)offset.x, (String)"graph.y", (Object)offset.y);
            builder.transformProperties(props -> Stream.concat(Stream.of(Map.entry(META, GraphElement.property((Value)meta))), props).toList());
        }
        return builder.build();
    }

    static final class ImportPaste
    extends PositionTransform
    implements ModelTransform.Import,
    ModelTransform.Paste {
        ImportPaste(GraphEditor editor) {
            super(editor);
        }

        public GraphModel apply(GraphModel model) {
            return this.offset(model, this.editor.getActivePoint());
        }
    }

    static final class CopyExport
    extends PositionTransform
    implements ModelTransform.Copy,
    ModelTransform.Export {
        CopyExport(GraphEditor editor) {
            super(editor);
        }

        public GraphModel apply(GraphModel model) {
            List<Point> positions = this.findPositions(model);
            int minX = positions.stream().mapToInt(p -> p.x).min().orElse(0);
            int minY = positions.stream().mapToInt(p -> p.y).min().orElse(0);
            return this.offset(model, new Point(-minX, -minY));
        }
    }
}

