/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.ide.pxr.graph.scene;

import java.awt.Point;
import java.awt.Rectangle;
import org.netbeans.api.visual.anchor.Anchor;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.praxislive.ide.pxr.graph.scene.Alignment;
import org.praxislive.ide.pxr.graph.scene.LAFScheme;
import org.praxislive.ide.pxr.graph.scene.NodeWidget;
import org.praxislive.ide.pxr.graph.scene.PraxisGraphScene;

public class PinWidget
extends Widget {
    public static final String DEFAULT_CATEGORY = "";
    private final PraxisGraphScene scene;
    private final SceneListenerImpl sceneListener;
    private final NodeWidget node;
    private final LabelWidget nameWidget;
    private LAFScheme scheme;
    private LAFScheme.Colors schemeColors;
    private Alignment alignment;
    private String category;

    public PinWidget(PraxisGraphScene scene, NodeWidget node, String name) {
        super((Scene)scene);
        this.scene = scene;
        this.sceneListener = new SceneListenerImpl();
        this.node = node;
        this.scheme = scene.getLookAndFeel();
        this.schemeColors = node.getSchemeColors();
        this.alignment = Alignment.Center;
        this.category = DEFAULT_CATEGORY;
        this.setLayout(LayoutFactory.createVerticalFlowLayout());
        this.nameWidget = new LabelWidget((Scene)scene);
        this.addChild((Widget)this.nameWidget);
        this.nameWidget.setLabel(name);
        this.nameWidget.setAlignment(LabelWidget.Alignment.CENTER);
        this.scheme.installUI(this);
    }

    protected void notifyStateChanged(ObjectState previousState, ObjectState state) {
        this.scheme.updateUI(this);
    }

    protected void notifyAdded() {
        this.scene.addSceneListener(this.sceneListener);
    }

    protected void notifyRemoved() {
        this.scene.removeSceneListener(this.sceneListener);
    }

    public Widget getPinNameWidget() {
        return this.nameWidget;
    }

    public String getName() {
        return this.nameWidget.getLabel();
    }

    public void setSchemeColors(LAFScheme.Colors colors) {
        this.schemeColors = colors;
        this.revalidate();
    }

    public LAFScheme.Colors getSchemeColors() {
        return this.schemeColors == null ? this.node.getSchemeColors() : this.schemeColors;
    }

    public void setAlignment(Alignment alignment) {
        if (alignment == null) {
            throw new NullPointerException();
        }
        this.nameWidget.setAlignment(this.getLabelAlignment(alignment));
        this.alignment = alignment;
        this.scheme.updateUI(this);
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    private LabelWidget.Alignment getLabelAlignment(Alignment alignment) {
        switch (alignment) {
            case Left: {
                return LabelWidget.Alignment.LEFT;
            }
            case Right: {
                return LabelWidget.Alignment.RIGHT;
            }
        }
        return LabelWidget.Alignment.CENTER;
    }

    public Anchor createAnchor() {
        return new AlignedAnchor();
    }

    public boolean isHitAt(Point localLocation) {
        if (this.scene.isBelowLODThreshold()) {
            return false;
        }
        return super.isHitAt(localLocation);
    }

    private class SceneListenerImpl
    implements Scene.SceneListener {
        private SceneListenerImpl() {
        }

        public void sceneRepaint() {
        }

        public void sceneValidating() {
            PinWidget.this.scheme.updateUI(PinWidget.this);
        }

        public void sceneValidated() {
        }
    }

    private class AlignedAnchor
    extends Anchor {
        private AlignedAnchor() {
            super((Widget)PinWidget.this);
        }

        public Anchor.Result compute(Anchor.Entry entry) {
            Rectangle bounds = PinWidget.this.convertLocalToScene(PinWidget.this.getBounds());
            int centerY = bounds.y + bounds.height / 2;
            int gap = PinWidget.this.scheme.getAnchorGap();
            if (switch (PinWidget.this.alignment) {
                case Alignment.Left -> false;
                case Alignment.Right -> true;
                default -> {
                    Point opposite = this.getOppositeSceneLocation(entry);
                    yield opposite.x > bounds.x;
                }
            }) {
                return new Anchor.Result((Anchor)this, new Point(bounds.x + bounds.width + gap, centerY), Anchor.Direction.RIGHT);
            }
            return new Anchor.Result((Anchor)this, new Point(bounds.x - gap, centerY), Anchor.Direction.LEFT);
        }
    }
}

